package com.ejianc.foundation.permission.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class RoleUserRelationServiceImpl extends BaseServiceImpl<RoleUserRelationMapper, RoleUserRelationEntity>
		implements IRoleUserRelationService {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IOrgService orgService;

	@Autowired
	private RoleUserRelationMapper roleUserRelationMapper;
	@Autowired
	private PermissionCacheManage permissionCacheManage;

	@Override
	public List<RoleUserRelationVO> queryListByProperties(Map<String, Object> params) {
		return roleUserRelationMapper.queryListByProperties(params);
	}

	@Override
	public List<RoleUserRelationVO> queryExportList(Map<String, Object> params) {
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		params.remove("pageSize");
		return roleUserRelationMapper.queryPageByProperties(params);
	}

	@Override
	public IPage<RoleUserRelationVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = roleUserRelationMapper.countByProPerties(params);
		IPage<RoleUserRelationVO> page = new Page<RoleUserRelationVO>();
		if(count>0){
			List<RoleUserRelationVO> appVO = roleUserRelationMapper.queryPageByProperties(params);
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	public CommonResponse<String> delete(List<Long> ids) {
		for(Long id:ids) {
			RoleUserRelationEntity entity = roleUserRelationMapper.selectById(id);
			
			roleUserRelationMapper.deleteByPkId(id);
//			logger.info("删除的id：-------"+id);
//			logger.info("删除的RoleId：-------"+entity.getRoleId());
//			logger.info("删除的permissionCacheManage：-------"+permissionCacheManage);
			//删除redis中的用户
			permissionCacheManage.removeRoleUsersCache(entity.getRoleId(), entity.getUserId(), entity.getAuthOrgId());
		}
		return CommonResponse.success("删除角色用户成功");
	}

	@Override
	public CommonResponse<String> saveRoleUser(List<RoleUserRelationVO> data) {
		List<RoleUserRelationEntity> entityList = BeanMapper.mapList(data, RoleUserRelationEntity.class);
		if(entityList != null && entityList.size() > 0) {
			this.saveOrUpdateBatch(entityList , entityList.size(), false);
			permissionCacheManage.putRoleUsersCache(data.get(0).getRoleId(), data);
			return CommonResponse.success("保存成功");
		}else{
			return CommonResponse.error("未选择用户");
		}
	}
	
	@Override
	public List<RoleUserRelationVO> queryRoleUserList(List<Long> roleId, List<Long> authOrgId) {
		//先查询这些组织下面的直属的虚拟组织，将虚拟组织添加进查询---考虑虚拟组织不会重复建设，所以目前只查询一级
		if(authOrgId!=null&&authOrgId.size()>0){
			QueryWrapper<OrgEntity> wrapper = new QueryWrapper<>();
			wrapper.in("parent_id", authOrgId);
			wrapper.eq("dr", 0);
			List<OrgEntity> orgChildList = orgService.list(wrapper);
			for(OrgEntity entity : orgChildList){
				if(4 == entity.getOrgType()){
					authOrgId.add(entity.getId());
				}
			}
		}
		List<RoleUserRelationVO> list = roleUserRelationMapper.queryRoleUserList(roleId,authOrgId);
		List<RoleUserRelationVO> list2 = roleUserRelationMapper.queryRolePostUserList(roleId,authOrgId);
		List<RoleUserRelationVO> result = new ArrayList<>();
		if(list!=null && list.size()>0){
			result.addAll(list);
		}
		if(list2!=null && list2.size()>0){
			result.addAll(list2);
		}
		return result;
	}
	
	@Override
	public CommonResponse<String> deleteByJobIds(List<Long> jobIds) {
		Map<String, Object> params = new HashMap<>();
		params.put("jobIds", jobIds);
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		List<RoleUserRelationVO> roleList = roleUserRelationMapper.queryListByProperties(params);
		if(roleList!=null&&roleList.size()>0){
			//说明该job下存在角色
			List<Long> roleIds = new ArrayList<>();
			for(RoleUserRelationVO vo : roleList){
				roleIds.add(vo.getId());
			}
			this.delete(roleIds);
		}
		return CommonResponse.success("删除成功");
	}

	@Override
	public List<Long> findAllUidsByRoleNames(List<String> roleNames, Long tenantId) {
		return roleUserRelationMapper.findAllUidsByRoleNames(roleNames, tenantId);
	}

	/**
	 * 根据employeId查询
	 * @param params
	 * @param isEs
	 * @return
	 */
	public IPage<RoleUserRelationVO> queryRoleByEmployeeId(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
			long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
			params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = roleUserRelationMapper.countByEmployeeId(params);
		IPage<RoleUserRelationVO> page = new Page<RoleUserRelationVO>();
		if(count>0){
			List<RoleUserRelationVO> appVO = roleUserRelationMapper.queryRoleByEmployeeId(params);
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	public IPage<RoleUserRelationVO> querybookAppRoleDetails(Map<String, Object> params, boolean b) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
			long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
			params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = roleUserRelationMapper.countBookAppRole(params);
		IPage<RoleUserRelationVO> page = new Page<RoleUserRelationVO>();
		if(count>0){
			List<RoleUserRelationVO> appVO = roleUserRelationMapper.bookAppRoleDetailsList(params);
			page.setRecords(appVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	public List<RoleUserRelationVO> queryByEmployeeIdsList(List<Long> employeeIds) {
		return roleUserRelationMapper.queryByEmployeeIdsList(InvocationInfoProxy.getTenantid(),employeeIds);
	}

	@Override
	public List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userId) {
		return roleUserRelationMapper.findAllByRoleNameAndUserId(roleName, userId, null);
	}

	@Override
	public List<RoleUserRelationVO> findAllByRoleNameAndUserId(String roleName, Long userId, Long tenantId) {
		return roleUserRelationMapper.findAllByRoleNameAndUserId(roleName, userId, tenantId);
	}
}
