package com.ejianc.foundation.sign.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.sign.bean.SignEntity;
import com.ejianc.foundation.sign.service.ISignService;
import com.ejianc.foundation.sign.vo.SignVO;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.sign.mapper.SignMapper;

import java.util.List;


/**
 * 签名
 * 
 * @author generator
 * 
 */
@Service("signService")
public class SignServiceImpl extends BaseServiceImpl<SignMapper, SignEntity> implements ISignService {
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private ISignService signService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IEmployeeService employeeService;

    /**
     * pc人员手动上传签名处理
     * @param fileId
     */
    @Override
    public void updateFromEmpployee(Long userId, Long fileId, String fileUrl) {
        //将原先人员的默认签名去除
        QueryWrapper<SignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        queryWrapper.eq("default_flag","1");
        queryWrapper.eq("dr","0");
        List<SignEntity> list = this.list(queryWrapper);
        SignEntity defaultEntity = null;
        if(list!=null && list.size()>0){
            defaultEntity = list.get(0);
        }
        if(fileId!=null){
            if(defaultEntity!=null && !fileId.toString().equals(defaultEntity.getFileId())){
                //原先有默认签名，删除
                attachmentApi.delete(defaultEntity.getFileId());
                this.remove(queryWrapper, false);
            }
            if((defaultEntity!=null && !fileId.toString().equals(defaultEntity.getFileId())) || (defaultEntity==null)){
                //新增默认签名记录
                SignEntity signEntity = new SignEntity();
                signEntity.setDefaultFlag(true);
                signEntity.setFileId(fileId.toString());
                signEntity.setFileUrl(fileUrl);
                signEntity.setUserId(userId);
                signService.saveOrUpdate(signEntity,false);
            }
        }else{
            if(list!=null && list.size()>0){
                attachmentApi.delete(list.get(0).getFileId());
            }
            this.remove(queryWrapper, false);
        }
    }

    /**
     * 获取人员默认签名
     * @param userId
     */
    @Override
    public SignEntity getUserDefaultSign(Long userId) {
        //将原先人员的默认签名去除
        QueryWrapper<SignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        queryWrapper.eq("default_flag","1");
        queryWrapper.eq("dr","0");
        List<SignEntity> list = this.list(queryWrapper);
        if(list!=null && list.size()>0){
            return list.get(0);
        }else{
            return null;
        }
    }

    /**
     * 根据id修改状态
     * @param id
     */
    public void updateState(Long id) {
        SignEntity signEntity =this.selectById(id);
        this.updateUserId(signEntity.getUserId());
        signEntity.setDefaultFlag(true);
        EmployeeVO employee=employeeService.queryEmployeeByUserId(signEntity.getUserId());
        EmployeeEntity employeeEntity =BeanMapper.map(employee, EmployeeEntity.class);
        employeeEntity.setUserSignaturePath(signEntity.getFileUrl());
        employeeService.saveOrUpdate(employeeEntity,false);
        signService.saveOrUpdate(signEntity,false);
    }

    /**
     * 保存
     * @param entity
     * @param b
     * @return
     */
    public SignVO saveOrUpdates(SignEntity entity, boolean b) {
        if(selectDefaultFlag(entity.getUserId())){
            entity.setDefaultFlag(false);
        }
        super.saveOrUpdate(entity,false);
        SignVO vo =BeanMapper.map(entity, SignVO.class);
        return vo;
    }

    /**
     * 根据userId 修改
     * @param userId
     */
    public void updateUserId(Long userId){
        UpdateWrapper<SignEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("default_flag",false);
        updateWrapper.eq("user_id",userId);
        this.update(updateWrapper);
    }

    /**
     * 根据用户id查找是否存在数据
     * @param userId
     * @return
     */
    public Boolean selectDefaultFlag(Long userId){
        QueryWrapper<SignEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        queryWrapper.eq("dr","0");
        List list =signMapper.selectList(queryWrapper);
        if(CollectionUtil.isNotEmpty(list)){
            return true;
        }
        return false;
    }

    /**
     * 根据userId查询集合对象
     * @param userList
     * @return
     */
    public List<SignVO> queryByUserIdList(List<Long> userList) {
        QueryParam param = new QueryParam();
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter(QueryParam.IN, userList));
        param.getParams().put("defaultFlag", new Parameter(QueryParam.EQ, true));
        List<SignEntity> list =this.queryList(param);
        List<SignVO> voList =BeanMapper.mapList(list,SignVO.class);
        return voList;
    }
}
