package com.ejianc.foundation.workbench.service;



/**
 * 企业微信第三方应用 服务接口
 *
 */
public interface IWxeeThirdAppService {

    /**
     * 企业微信授权成功回调
     * @param tpmAuthCode 临时授权码
     */
    void openApp(String tpmAuthCode);

    /**
     * 企业微信授权 变更回调
     * @param authCorpId 授权企业id
     * @param suiteId 应用id
     */
    void changeAuth(String authCorpId,String suiteId);

    /**
     * 通讯录变更事件通知 新增成员
     * @param authCorpId 授权企业id
     * @param suiteId 应用id
     */
    void addUser(String authCorpId,String suiteId,String userId,String openUserID,String mobile);
    /**
     * 通讯录变更事件通知 修改成员
     * @param authCorpId 授权企业id
     * @param suiteId 应用id
     * @param state 状态标识 (1:启用，0：停用)
     */
    void changeUser(String authCorpId,String suiteId,String oldUserId,String newUserId,String openUserID,String mobile,Integer state);

}
