package com.ejianc.foundation.permission.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.permission.bean.*;
import com.ejianc.foundation.permission.service.*;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

@Service
public class AppServiceImpl extends BaseServiceImpl<AppMapper, AppEntity> implements IAppService {

	private static final String APP_BILL_CODE = "IDM_APP";
	
	@Value("${oms.tenantid}")
	private Long omsTenantid;
	
	@Autowired
	private IButtonService buttonService;
	@Autowired
	private IRoleAppRelationService roleAppRelationService;
	@Autowired
	private IRoleButtonRelationService roleButtonRelationService;
	@Autowired
	private IModuleApi moduleApi;
	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private AppMapper appMapper;
	@Autowired
	private AppCacheManage appCacheManage;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IParamConfigApi paramConfigApi;
	@Autowired
	private IMangerUserAppRelationService mangerUserAppRelationService;

	@Override
	public CommonResponse<String> save(AppVO applicationVo, boolean syncEs) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		AppEntity entity = new AppEntity();
		boolean isAdd = true;
		if(applicationVo.getId()!=null){
			//修改
			AppEntity oldEntity = super.getById(applicationVo.getId());
			if(StringUtils.isNotBlank(oldEntity.getAppIconSrc())){
				if(StringUtils.isNotBlank(applicationVo.getAppIconSrc())){
					if(!oldEntity.getAppIconSrc().equals(applicationVo.getAppIconSrc())){
						//删除原先的应用
						if(StringUtils.isNotBlank(oldEntity.getAppIconSrc())&&oldEntity.getAppIconSrc().contains("=")){
							String id = oldEntity.getAppIconSrc().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								attachmentApi.delete(id);
							}
						}
						//绑定新的应用图标
						if(StringUtils.isNotBlank(applicationVo.getAppIconSrc())&&applicationVo.getAppIconSrc().contains("=")){
							String id = applicationVo.getAppIconSrc().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								List<Long> attachIds = new ArrayList<>();
								attachIds.add(Long.parseLong(id));
								attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
							}
						}
					}
					
				}else{
					//删除原先的应用
					if(StringUtils.isNotBlank(oldEntity.getAppIconSrc())&&oldEntity.getAppIconSrc().contains("=")){
						String id = oldEntity.getAppIconSrc().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							attachmentApi.delete(id);
						}
					}
				}
			}else{
				if(StringUtils.isNotBlank(applicationVo.getAppIconSrc())){
					//绑定新的应用图标
					if(StringUtils.isNotBlank(applicationVo.getAppIconSrc())&&applicationVo.getAppIconSrc().contains("=")){
						String id = applicationVo.getAppIconSrc().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							List<Long> attachIds = new ArrayList<>();
							attachIds.add(Long.parseLong(id));
							attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
						}
					}
				}
			}
			oldEntity.setCode(applicationVo.getCode());
			oldEntity.setName(applicationVo.getName());
			oldEntity.setSequence(applicationVo.getSequence());
			oldEntity.setBtnPower(applicationVo.getBtnPower());
			oldEntity.setModuleId(applicationVo.getModuleId());
			oldEntity.setNotes(applicationVo.getNotes());
			oldEntity.setSource(applicationVo.getSource());
			oldEntity.setAppAddPath(applicationVo.getAppAddPath());
			if(applicationVo.getSource()==2){
				//变为外部应用
				oldEntity.setClassify(applicationVo.getClassify());
				oldEntity.setPcUrl("/portal/outer/sso/redirect?appcode="+oldEntity.getCode());
				oldEntity.setMobileUrl("");
			}else{
				oldEntity.setClassify(applicationVo.getClassify());
				oldEntity.setPcUrl(applicationVo.getPcUrl());
				oldEntity.setMobileUrl(applicationVo.getMobileUrl());
			}
			oldEntity.setAppIconSrc(applicationVo.getAppIconSrc());
			oldEntity.setOpenMode(applicationVo.getOpenMode());
			oldEntity.setType(applicationVo.getType());
			oldEntity.setBillTypes(BeanMapper.mapList(applicationVo.getBillTypes(),AppBillEntity.class));
			entity = BeanMapper.map(oldEntity, AppEntity.class);
			isAdd = false;
		}else{
			//新增
			CommonResponse<String> appResponse = billCodeApi.getCodeBatchByRuleCode(APP_BILL_CODE, tenantId);
        	if(appResponse.isSuccess()) {
        		applicationVo.setCode(appResponse.getData());
        	}else{
        		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
        	}
			if(applicationVo.getSource()==2){
				//变为外部应用
				applicationVo.setPcUrl("/portal/outer/sso/redirect?appcode="+applicationVo.getCode());
				applicationVo.setMobileUrl("");
			}
			applicationVo.setDr(0);
			entity = BeanMapper.map(applicationVo, AppEntity.class);
			
			isAdd = true;
		}
		this.saveOrUpdate(entity, syncEs);
		List<ButtonVO> btnPowers = applicationVo.getChildren();
		List<ButtonEntity> btnPowerEntitys = new ArrayList<>();
		List<Long> delbtnPowersIds = new ArrayList<>();
		List<ButtonVO> delBtn = new ArrayList<>();
		for(ButtonVO vo : btnPowers){
			if(StringUtils.isNotBlank(vo.getRowState())&&vo.getRowState().equals("add")){
				ButtonEntity en = BeanMapper.map(vo, ButtonEntity.class);
				en.setAppId(entity.getId());
				en.setDr(0);
				btnPowerEntitys.add(en);
			}
			if(StringUtils.isNotBlank(vo.getRowState())&&vo.getRowState().equals("edit")){
				ButtonEntity en = BeanMapper.map(vo, ButtonEntity.class);
				btnPowerEntitys.add(en);
			}
			if(StringUtils.isNotBlank(vo.getRowState())&&vo.getRowState().equals("del")){
				delbtnPowersIds.add(vo.getId());
				delBtn.add(vo);
			}
		}
		if(btnPowerEntitys.size()>0){
			buttonService.saveOrUpdateBatch(btnPowerEntitys, btnPowerEntitys.size(), syncEs);
		}
		if(delbtnPowersIds.size()>0){
			buttonService.removeByIds(delbtnPowersIds, syncEs);
		}
		
		/**
		 * 把应用放入缓存
		 */
		appCacheManage.putAppBeanToCache(tenantId, BeanMapper.map(entity, AppVO.class));

		/** 把按钮放入缓存 */
		if(ListUtil.isNotEmpty(btnPowerEntitys)){
			appCacheManage.putBtnToCache(BeanMapper.mapList(btnPowerEntitys,ButtonVO.class));
		}
		/** 删除按钮缓存 */
		appCacheManage.rmBtnFromCache(delBtn);
		if(ListUtil.isNotEmpty(delbtnPowersIds)){
			/** 删除授权按钮角色缓存 */
			QueryParam param = new QueryParam();
			param.getParams().put("buttonId",new Parameter(QueryParam.IN,delbtnPowersIds));
			List<RoleButtonRelationEntity> roleButtonRelationEntities = roleButtonRelationService.queryList(param);
			if(ListUtil.isNotEmpty(roleButtonRelationEntities)){
				appCacheManage.rmBtnRoleFromCache(delBtn,roleButtonRelationEntities.stream().map(RoleButtonRelationEntity::getRoleId).collect(Collectors.toList()));
			}
		}

		if(isAdd) {
			return CommonResponse.success("保存成功");
		}else{
			return CommonResponse.success("修改成功");
		}
	}

	@Override
	public CommonResponse<String> delete(List<Long> ids) {
		QueryWrapper<RoleAppRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("dr", 0);
		queryWrapper.in("app_id", ids);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		//删除前校验该应用有没有被分配给角色，若分配给角色则不能删除
		List<RoleAppRelationEntity> list = roleAppRelationService.list(queryWrapper );
		if(list.size()>0){
			List<Long> appIds = new ArrayList<>();
			list.forEach(e->{
				appIds.add(e.getAppId());
			});
			List<AppEntity> appList = (List<AppEntity>) this.listByIds(appIds);
			if(appList.size()>0){
				String message = "";
				for(AppEntity app : appList){
					if(message.length()>0){
						message += ("、"+app.getName());
					}else{
						message += app.getName();
					}
				}
				throw new BusinessException(message+"已被分配角色，请先删除角色与应用的关系");
			}
		}
		
		super.removeByIds(ids);
		//删除应用缓存
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long appId:ids) {
			appCacheManage.removeAppCache(tenantId, appId);
		}
		return CommonResponse.success("删除成功");
	}

	@Override
	public AppVO queryDetail(Long id) {
		AppEntity entity = selectById(id);
		if(entity != null) {
			AppVO vo = BeanMapper.map(entity, AppVO.class);
			//查询按钮信息
			QueryWrapper<ButtonEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("app_id", id);
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("sequence");
			List<ButtonEntity> rtnPowers = buttonService.querylist(queryWrapper);
			List<ButtonVO> vos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
			vo.setChildren(vos);
            CommonResponse<ModuleVO>  moduleVO = moduleApi.getModuleById(entity.getModuleId());
			if(moduleVO.isSuccess()&&moduleVO.getData()!=null){
				vo.setModuleName(moduleVO.getData().getModuleName());
			}
			return vo;
		}
		throw new BusinessException("未查询到该主键对应的详情");
	}

	@Override
	public List<AppVO> queryListByModuleId(Long moduleId, Long roleId, String searchText) {

		List<Long> moduleIds = new ArrayList<>();
		CommonResponse<List<ModuleVO>> moduleResponse = moduleApi.queryModuleListByPid(moduleId);
		if(moduleResponse.isSuccess()) {
			List<ModuleVO> modules= moduleResponse.getData();
			for(int i=0;i<modules.size();i++) {
				moduleIds.add(modules.get(i).getId());
			}
		}
		List<AppEntity> list;
		boolean authLevelOpen = false;//分级授权是否开启
		List<Long> appIds = new ArrayList<>();
		CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode("P-20X5K80186");
		if(!Objects.equals(InvocationInfoProxy.getUserType(),"1") &&response.isSuccess() && Objects.equals("1",response.getData().getValueData())){
			authLevelOpen = true;
			/** 开启分级授权 ，非超级管理员，查询分级授权的应用 */
			QueryParam param = new QueryParam();
			param.getParams().put("userId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUserid()));
			param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
			List<MangerUserAppRelationEntity> appRelationEntities = mangerUserAppRelationService.queryList(param);
			if(ListUtil.isEmpty(appRelationEntities)){
				return new ArrayList<>();
			}
			/** 查询当前租户的套餐内已过期失效的应用 */
			List<AppEntity> appEntity = queryComboAppUseless();
			if(ListUtil.isNotEmpty(appEntity)){
				List<Long> omAppIds = appEntity.stream().map(AppEntity::getId).collect(Collectors.toList());
				for (Long aLong : appRelationEntities.stream().map(MangerUserAppRelationEntity::getAppId).collect(Collectors.toList())) {
					if(!omAppIds.contains(aLong)){
						/** 说明应用还生效 */
						appIds.add(aLong);
					}
				}
			}else {
				for (Long aLong : appRelationEntities.stream().map(MangerUserAppRelationEntity::getAppId).collect(Collectors.toList())) {
					/** 说明没有过期应用 */
					appIds.add(aLong);
				}
			}
			/** 说明套餐内应用都失效了 */
			if(ListUtil.isEmpty(appIds)){
				return new ArrayList<>();
			}
			param = new QueryParam();
			param.getParams().put("id",new Parameter(QueryParam.IN,appIds));
			param.getParams().put("module_id",new Parameter(QueryParam.IN,moduleIds));
			list = queryList(param);
		}else {
			//查询全部应用权限
			if(InvocationInfoProxy.getTenantid().equals(omsTenantid)){
				//全局级（即租户为999999）分组（本下分组）的所有应用详情（包括按钮权限）
				QueryWrapper<AppEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("dr", 0);
				queryWrapper.in("module_id", moduleIds);
				queryWrapper.in("classify", 2,3);
				if(StringUtils.isNotBlank(searchText)){
					queryWrapper.like("name",searchText);
				}
				queryWrapper.orderByAsc("sequence");
				queryWrapper.orderByDesc("create_time");
				list = this.list(queryWrapper);
			}else{
				//普通租户级--查询租户分配套餐下的应用详情（包括按钮权限）
				list = appMapper.queryAuthAppByTenantId(InvocationInfoProxy.getTenantid(),moduleIds,searchText);
			}
		}
		//查询该角色已授权的应用
		List<AppVO> selfRoleApp = roleAppRelationService.queryAuthListByRoleId(roleId);
		Map<Long , Long> selfRoleMap = new HashMap<>();
		if(selfRoleApp != null && selfRoleApp.size() > 0) {
			for(AppVO appVo:selfRoleApp) {
				selfRoleMap.put(appVo.getId(), appVo.getId());
			}
		}
		List<AppVO> vos = new ArrayList<>();
		for(AppEntity entity : list){
			AppVO vo = BeanMapper.map(entity, AppVO.class);
			if(!selfRoleMap.containsKey(vo.getId())){ //未授权
				if(vo.getBtnPower()==1){//开启按钮权限，则查询所有按钮
					QueryWrapper<ButtonEntity> wrapper = new QueryWrapper<>();
					wrapper.eq("app_id", vo.getId());
					wrapper.eq("dr", 0);
					wrapper.orderByAsc("sequence");
					List<ButtonEntity> rtnPowers = buttonService.querylist(wrapper);
					List<ButtonVO> btnvos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
					if(ListUtil.isNotEmpty(btnvos)) {
						if(authLevelOpen){
							/** 开启了分级授权，获取分级授权按钮权限 */
							for(ButtonVO buttonVo:btnvos) {
								boolean content = false;
								for (Long appId : appIds) {
									if(appId.equals(buttonVo.getId())){
										content = true;//包含,说明已授权
									}
								}
								if(content){//已授权，再把按钮权限放出来
									vo.getChildren().add(buttonVo);
								}
							}
						}else {
							for(ButtonVO buttonVo:btnvos) {
								vo.getChildren().add(buttonVo);
							}
						}
					}
					vos.add(vo);
				}else{
					vos.add(vo);
				}
			}else{ //已授权,需要判断按钮是否已经全部授完权限
				//判断是否开启按钮权限
				if(vo.getBtnPower() == 1) {
					QueryWrapper<ButtonEntity> wrapper = new QueryWrapper<>();
					wrapper.eq("app_id", vo.getId());
					wrapper.eq("dr", 0);
					wrapper.orderByAsc("sequence");
					List<ButtonEntity> rtnPowers = buttonService.querylist(wrapper);
					List<ButtonVO> btnvos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
					if(btnvos != null && btnvos.size() > 0) {
						if(authLevelOpen){
							/** 开启了分级授权，获取分级授权按钮权限 */
							for(ButtonVO buttonVo:btnvos) {
								boolean content = false;
								if(appIds.contains(buttonVo.getId())){
									content = true;//包含,说明已授权
								}
								if(content){//已授权，再把按钮权限放出来
									if(!selfRoleMap.containsKey(buttonVo.getId())) {
										vo.getChildren().add(buttonVo);
									}
								}
							}
						}else {
							for(ButtonVO buttonVo:btnvos) {
								if(!selfRoleMap.containsKey(buttonVo.getId())) {
									vo.getChildren().add(buttonVo);
								}
							}
						}
					}
					if(vo.getChildren().size() > 0) {
						vos.add(vo);
					}
				}
			}
		}
        return vos;
	}

	@Override
	public List<AppEntity> queryAllByIds(List<Long> appIds) {
		return baseMapper.selectBatchIds(appIds);
	}

	/**
	 * 保存角色应用关系
	 */
	@Override
	public CommonResponse<String> saveRoleApp(RoleAppVO roleAppVO) {
		if(roleAppVO.getRoleId()!=null){
			List<AppVO> appVo = roleAppVO.getAppVO();
			if(appVo!=null){
				Long roleId = roleAppVO.getRoleId();
				//保存按钮关系表
				List<RoleAppRelationEntity> appList = new ArrayList<>();
				List<RoleButtonRelationEntity> btnList = new ArrayList<>();
				for(AppVO vo : appVo){
					RoleAppRelationEntity appEntity = new RoleAppRelationEntity();
					appEntity.setAppId(vo.getId());
					appEntity.setRoleId(roleId);
					appEntity.setTenantId(vo.getTenantId());
					appList.add(appEntity);
					List<ButtonVO> btn = vo.getChildren()!=null? vo.getChildren(): new ArrayList<>();
					for(ButtonVO bt : btn){
						RoleButtonRelationEntity bentity = new RoleButtonRelationEntity();
						bentity.setAppId(vo.getId());
						bentity.setRoleId(roleId);
						bentity.setButtonId(bt.getId());
						btnList.add(bentity);
					}
				}
				if(appList.size()>0){
					roleAppRelationService.saveOrUpdateBatch(appList, appList.size(), false);
				}
				if(btnList.size()>0){
					roleButtonRelationService.saveOrUpdateBatch(btnList, btnList.size(), false);
				}
				
				//更新redis
				permissionCacheManage.putRoleAppsCache(roleId, appVo);
			}else{
				return CommonResponse.error("保存应用数据为空");
			}
		}else{
			return CommonResponse.error("角色id不能为空");
		}
		
		return CommonResponse.success("保存成功");
	}

	@Override
	public List<AppVO> queryList(Map<String, Object> params) {
		List<AppEntity> entitys = new ArrayList<>();
		//不是平台租户
		if(!InvocationInfoProxy.getTenantid().equals(omsTenantid)){
			//根据套餐分配查询该租户有权限的平台应用
			entitys = appMapper.queryList(InvocationInfoProxy.getTenantid());
		}else{
			//是平台租户
			QueryWrapper<AppEntity> queryWrapper = new QueryWrapper<>();
			for(String key : params.keySet()){
				if(key.equals("classify")){
					//查询平台运营应用
					if(params.get(key).equals("oms")){
						queryWrapper.eq(key, 1).or().eq(key, 3);
					}else{
						queryWrapper.eq(key, params.get(key));
					}
				}else{
					queryWrapper.eq(key, params.get(key));
				}
			}
			queryWrapper.eq("dr", 0);
			queryWrapper.orderByAsc("sequence");
			queryWrapper.orderByDesc("create_time");
			entitys = baseMapper.selectList(queryWrapper);
		}
		
		return BeanMapper.mapList(entitys, AppVO.class);
	}

	@Override
	public List<Long> queryAllOperateList() {
		List<Long> appIds = appMapper.queryAllOperateList();
		return appIds;
	}

	@Override
	public List<Long> queryAllOmsOprateList() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> appIds = appMapper.queryAllOmsOprateList(tenantId);
		return appIds;
	}

	@Override
	public List<Long> queryAllHasAuthOmsOprateList() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> appIds = appMapper.queryAllHasAuthOmsOprateList(tenantId);
		return appIds;
	}

	@Override
	public List<AppVO> queryAppByUser() {
		return null;
	}

	/**
	 * 租户查询 租户套餐内应用
	 *
	 * @return
	 */
	@Override
	public List<AppEntity> queryComboApp() {
		Map<String, Object> params = new HashMap<>();
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		return appMapper.queryComboApp(params);
	}
	/**
	 * 查询当前租户的套餐内已过期失效的应用
	 *
	 * @return
	 */
	@Override
	public List<AppEntity> queryComboAppUseless() {
		Map<String, Object> params = new HashMap<>();
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		return appMapper.queryComboAppUseless(params);
	}

	@Override
	public List<Long> queryAuthOperateList() {
		Long userId = InvocationInfoProxy.getUserid();
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> appIds = appMapper.queryAuthOperateList(userId, tenantId);
		return appIds;
	}
	
	@Override
	public List<Long> queryAuthOperateOmsList() {
		Long userId = InvocationInfoProxy.getUserid();
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<Long> appIds = appMapper.queryAuthOperateOmsList(userId, tenantId);
		return appIds;
	}

	@Override
	public void refreshAppCache() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		QueryWrapper<AppEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		queryWrapper.orderByAsc("sequence");
		List<AppEntity> entities = appMapper.selectList(queryWrapper);
		if(entities != null && entities.size() > 0) {
			List<AppVO> appVoList = BeanMapper.mapList(entities, AppVO.class);
			appCacheManage.putAppListToCache(tenantId, appVoList);
			QueryWrapper<ButtonEntity> wrapper = new QueryWrapper<>();
			entities.forEach(app->{
				wrapper.eq("dr", 0);
				wrapper.eq("app_id", app.getId());
				List<ButtonEntity> rtnPowers = buttonService.querylist(wrapper);
				appCacheManage.putBtnToCache(BeanMapper.mapList(rtnPowers,ButtonVO.class));
			});
		}
	}

	@Override
	public IPage<AppEntity> queryTenantAppList(int pageSize, int pageNumber, String searchText, String condition) {
		Map<String, Object> params = new HashMap<>();
		params.put("pageIndex", pageNumber);
		params.put("pageSize", pageSize);
		if(StringUtils.isNotBlank(searchText)){
			params.put("searchText", searchText);
		}
		//查询当前租户的套餐内的应用
		if(params.get("pageIndex")!=null){
			Integer pn = pageNumber - 1 < 0 ? 1 : pageNumber;
			long startLine = (pn - 1) * pageSize;
			params.put("startLine", startLine);
		}
		if(org.apache.commons.lang3.StringUtils.isNotEmpty(condition)){
			JSONObject object = JSONObject.parseObject(condition);
			if(org.apache.commons.lang3.StringUtils.isNotEmpty(object.getString("classify"))){
				params.put("classify", object.getString("classify"));
			}
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = appMapper.countComboApp(params);
		IPage<AppEntity> page = new Page<AppEntity>();
		if(count>0){
			List<AppEntity> appEntity = appMapper.queryComboApp(params);
			page.setRecords(appEntity);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	//查询套餐内的应用
	@Override
	public IPage<AppEntity> wzxtRefAppList(int pageSize, int pageNumber,String condition) {
		return this.queryTenantAppList(pageSize, pageNumber, null, condition);
	}

}
