package com.ejianc.foundation.websiteConsult.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 官网咨询--解决方案、客户案例
 * 
 * @author liyongjia
 */
public class WebsiteConsultVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	private String title; // 新闻标题

	private String introduce; // 简介

	private String filePath; // 封面图片

	private String content; // 内容

	private String author; // 作者

	private String type;

	private String sequence;

	private String day;

	private String month;

	private String videoPath; // 视频地址

//	private String videoPlayTime;//视频播放时间

	private Long videoPlayCount;//视频播放量

	private Long videoLikesCount;//视频点赞次数

	private Long videoShareCount;//视频分享次数

	/**
	 * 发布时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date publishTime;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSequence() {
		return sequence;
	}

	public void setSequence(String sequence) {
		this.sequence = sequence;
	}

	public String getDay() {
		String d = null;
		if(this.getPublishTime()!=null){
			Integer da = this.getPublishTime().getDay();
			d = da.toString();
		}
		return d;
	}

	public void setDay(String day) {
		this.day = day;
	}

	public String getMonth() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		String d = null;
		if(this.getPublishTime()!=null){
			d = formatter.format(this.getPublishTime());
		}
		return d;
	}

	public void setMonth(String month) {
		this.month = month;
	}

	public String getVideoPath() {
		return videoPath;
	}

	public void setVideoPath(String videoPath) {
		this.videoPath = videoPath;
	}

//	public String getVideoPlayTime() {
//		return videoPlayTime;
//	}
//
//	public void setVideoPlayTime(String videoPlayTime) {
//		this.videoPlayTime = videoPlayTime;
//	}

	public Long getVideoPlayCount() {
		return videoPlayCount;
	}

	public void setVideoPlayCount(Long videoPlayCount) {
		this.videoPlayCount = videoPlayCount;
	}

	public Long getVideoLikesCount() {
		return videoLikesCount;
	}

	public void setVideoLikesCount(Long videoLikesCount) {
		this.videoLikesCount = videoLikesCount;
	}

	public Long getVideoShareCount() {
		return videoShareCount;
	}

	public void setVideoShareCount(Long videoShareCount) {
		this.videoShareCount = videoShareCount;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}
}
