package com.ejianc.foundation.cache;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModuleCacheManage {

    // 所有模块缓存
    private final static String MODEL_CACHE_KEY = "model_cache_key:";
    @Autowired
    private CacheManager cacheManager;

    public void putModuleVOToCache(Long tenantId, ModuleVO moduleVO) {
        String key = MODEL_CACHE_KEY + tenantId;
        cacheManager.hset(key, moduleVO.getId().toString(), JSON.toJSONString(moduleVO));
    }

    public ModuleVO getModuleVOFromCache(Long tenantId, Long moduleId) {
        String key = MODEL_CACHE_KEY + tenantId;
        String content = cacheManager.hget(key, moduleId.toString());
        ModuleVO moduleVO = JSON.parseObject(content, ModuleVO.class);
        return moduleVO;
    }
}
