package com.ejianc.foundation.helpcenter.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.helpcenter.bean.ScGroupEntity;
import com.ejianc.foundation.helpcenter.mapper.ScGroupMapper;
import com.ejianc.foundation.helpcenter.service.IScGroupService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class ScGroupServiceImpl extends BaseServiceImpl<ScGroupMapper, ScGroupEntity> implements IScGroupService {
	
	@Autowired
	private ScGroupMapper scGroupMapper;

	@Override
	public List<ScGroupEntity> queryListByPid(Long id) {
		QueryWrapper<ScGroupEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", id);
		List<ScGroupEntity> resultList = super.list(queryWrapper);
		return resultList;
	}

	@Override
	public List<ScGroupEntity> queryParents(String innerCode) {
		List<ScGroupEntity> resultList = scGroupMapper.queryParents(innerCode);
		return resultList;
	}

}
