package com.ejianc.foundation.nav.bean;

import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 模块导航图
 * 
 * @author generator
 * 
 */
 @TableName("ejc_idm_nav_mode")
public class NavModeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 模块名称
    @TableField(value="file_url")
    private String fileUrl; // 图片地址
    @TableField(value="pid")
    private Long pid; // 租户引用的999999的模块的id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="navModeBaseService")
    private List<NavModeBaseEntity> navModeBaseList = new ArrayList<>(); // 模块导航图基础导航图标
    

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    

    public List<NavModeBaseEntity> getNavModeBaseList() {
        return navModeBaseList;
    }

    public void setNavModeBaseList(List<NavModeBaseEntity> navModeBaseList) {
        this.navModeBaseList = navModeBaseList;
    }
}
