package com.ejianc.foundation.nav.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.foundation.nav.vo.NavModeBaseAppVO;

/**
 * 模块导航图基础导航图标
 * 
 * @author generator
 * 
 */
public class NavModeBaseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 显示名称
    private String leftTop; // 左上角坐标
    private String rightBottom; // 右下角坐标
    private String type; // 类型：model：弹窗；url：链接应用
    private String alertName; // 弹窗名称
    private String appUrl; // 应用跳转地址
    private String fileUrl; // 图片地址
    private Long appId; // 应用id
    private Long pid; // 模块id
    private Integer width; // 弹窗宽度
    private Integer height; // 弹窗高度

    private List<NavModeBaseAppVO> navModeBaseAppList = new ArrayList<>(); // 模块导航图弹窗应用配置

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getLeftTop() {
        return leftTop;
    }

    public void setLeftTop(String leftTop) {
        this.leftTop = leftTop;
    }
    public String getRightBottom() {
        return rightBottom;
    }

    public void setRightBottom(String rightBottom) {
        this.rightBottom = rightBottom;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public String getAlertName() {
        return alertName;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }
    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode = "ejc_idm_app")
    public Long getAppId() {
        return appId;
    }

    @ReferDeserialTransfer
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<NavModeBaseAppVO> getNavModeBaseAppList() {
        return navModeBaseAppList;
     }

     public void setNavModeBaseAppList(List<NavModeBaseAppVO> navModeBaseAppList) {
        this.navModeBaseAppList = navModeBaseAppList;
     }
}
