package com.ejianc.foundation.usercenter.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserManagerRelationAppEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.mapper.UserManagerRelationAppMapper;
import com.ejianc.foundation.usercenter.service.IUserManagerRelationAppService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.vo.UserManagerAppRelationVO;
import com.ejianc.foundation.usercenter.vo.UserManagerRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class UserManagerRelationAppServiceImpl extends BaseServiceImpl<UserManagerRelationAppMapper, UserManagerRelationAppEntity> implements IUserManagerRelationAppService {

	@Autowired
	private UserManagerRelationAppMapper userManagerRelationMapper;

    @Autowired
    private IUserService userService;
	@Autowired
	private IUserTenantRelationService userTenantRelationService;

	@Override
	public IPage<UserManagerRelationVO> queryManagerList(Map<String, Object> params) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}

        List<UserManagerRelationVO> voList = new ArrayList<>();
        IPage<UserManagerRelationVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));
        long total = userManagerRelationMapper.countManagerList(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        voList = userManagerRelationMapper.queryManagerList(params);
        if(voList!=null&&voList.size()>0){
        	for(UserManagerRelationVO vo : voList){
        		if(vo.getTypeId()==1){
        			//超级管理员
        		}else{
        			//普通管理员
        			List<UserManagerAppRelationVO> list = userManagerRelationMapper.queryAppListbyUserId(vo.getUserId(),InvocationInfoProxy.getTenantid());
        			vo.setRelationList(list);
        		}
        	}
        }
        page.setRecords(voList);
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> save(UserManagerRelationVO relationVO, boolean b) {
		//删除该用户所有应用
		Map<String, Object> columnMap = new HashMap<>();
		columnMap.put("user_id", relationVO.getUserId());
		columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
		userManagerRelationMapper.deleteByMap(columnMap);
		//新增应用权限关系
		if(relationVO.getRelationList()!=null&&relationVO.getRelationList().size()>0){
			List<UserManagerAppRelationVO> list = relationVO.getRelationList();
			List<UserManagerRelationAppEntity> entitys = BeanMapper.mapList(list , UserManagerRelationAppEntity.class);
			this.saveOrUpdateBatch(entitys);
		}
		UserTenantRelationEntity userTenantRelation = userTenantRelationService.getOne(relationVO.getUserId(), null);
		userTenantRelation.setTypeId(3);
		userTenantRelation.setManagerNotes(relationVO.getManagerNotes());
		if(userTenantRelation.getMainSpaceFlag()==1){
			//是主空间--修改用户表信息
			//查询用户信息并修改
			UserEntity entity = userService.getById(relationVO.getUserId());
			entity.setTypeId(3);
			entity.setManagerNotes(relationVO.getManagerNotes());
			userService.saveOrUpdate(entity, false);
		}
		userTenantRelationService.saveOrUpdate(userTenantRelation, false);
		return CommonResponse.success("保存成功");
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(Long userId) {
		//删除该用户所有应用
		Map<String, Object> columnMap = new HashMap<>();
		columnMap.put("user_id", userId);
		columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
		userManagerRelationMapper.deleteByMap(columnMap);

		UserTenantRelationEntity userTenantRelation = userTenantRelationService.getOne(userId, null);
		userTenantRelation.setTypeId(2);
		userTenantRelation.setManagerNotes(null);
		if(userTenantRelation.getMainSpaceFlag()==1){
			//是主空间--修改用户表信息
			//查询用户信息并修改
			UserEntity entity = userService.getById(userId);
			entity.setTypeId(2);
			entity.setManagerNotes(null);
			userService.saveOrUpdate(entity, false);
		}
		userTenantRelationService.saveOrUpdate(userTenantRelation, false);
		return CommonResponse.success("删除用户成功");
	}

	@Override
	public CommonResponse<String> removeManager(Long sourceUserId, Long targetUserId, String managerNotes) {
		UserTenantRelationEntity sourceUserTenantRelation = userTenantRelationService.getOne(sourceUserId, null);
		sourceUserTenantRelation.setTypeId(2);
		sourceUserTenantRelation.setManagerNotes(null);
		if(sourceUserTenantRelation.getMainSpaceFlag()==1){
			//是主空间--修改用户表信息
			//查询用户信息并修改
			UserEntity sourceEntity = userService.getById(sourceUserId);
			sourceEntity.setTypeId(2);
			sourceEntity.setManagerNotes(null);
			userService.saveOrUpdate(sourceEntity, false);
		}
		userTenantRelationService.saveOrUpdate(sourceUserTenantRelation, false);

		UserTenantRelationEntity targetUserTenantRelation = userTenantRelationService.getOne(targetUserId, null);
		targetUserTenantRelation.setTypeId(1);
		targetUserTenantRelation.setManagerNotes(managerNotes);
		if(sourceUserTenantRelation.getMainSpaceFlag()==1){
			//是主空间--修改用户表信息
			//查询用户信息并修改
			UserEntity targetEntity = userService.getById(targetUserId);
			targetEntity.setTypeId(1);
			targetEntity.setManagerNotes(managerNotes);
			userService.saveOrUpdate(targetEntity, false);
		}
		userTenantRelationService.saveOrUpdate(targetUserTenantRelation, false);
		//若原先的用户存在应用关系则先删除
		Map<String, Object> columnMap = new HashMap<>();
		columnMap.put("user_id", targetUserId);
		columnMap.put("tenant_id", InvocationInfoProxy.getTenantid());
		userManagerRelationMapper.deleteByMap(columnMap);
		return CommonResponse.success("移交管理员成功");
	}

	//供方协同----查询用户的应用权限
	@Override
	public IPage<AppEntity> queryUserAppList(Map<String, Object> params) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = userManagerRelationMapper.countUserAppList(params);
		IPage<AppEntity> page = new Page<AppEntity>();
		if(count>0){
			List<AppEntity> appEntity = userManagerRelationMapper.queryUserAppList(params);
			page.setRecords(appEntity);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	public CommonResponse<String> saveUserApp(List<UserManagerAppRelationVO> relationVO) {
		Map<String, Object> params = new HashMap<>();
		params.put("userId", relationVO.get(0).getUserId());
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		List<AppEntity> appVO = userManagerRelationMapper.queryUserAppList(params);
		String message = "";
		List<UserManagerRelationAppEntity> entitys = new ArrayList<>();
		if(appVO!=null&&appVO.size()>0){
			Map<Long,Long> map = new HashMap<>();
			appVO.forEach(e -> {
				map.put(e.getId(), e.getId());
			});
			for(UserManagerAppRelationVO vo : relationVO){
				if(map.get(vo.getAppId())!=null){
					//该应用已存在，不保存
					if(message.length()>0){
						message += ("、"+vo.getAppName());
					}else{
						message += (vo.getAppName());
					}
				}else{
					entitys.add(BeanMapper.map(vo, UserManagerRelationAppEntity.class));
				}
			}
			if(entitys!=null&&entitys.size()>0){
				this.saveOrUpdateBatch(entitys,entitys.size(), false);
			}
		}else{
			entitys = BeanMapper.mapList(relationVO, UserManagerRelationAppEntity.class);
			this.saveOrUpdateBatch(entitys,entitys.size(), false);
		}
		if(message.length()>0){
			if(entitys.size()>0){
				//说明选择的有已存在的；
				return CommonResponse.success("分配应用权限成功，其中"+message+"已存在");
			}else{
				//选择的全部是已存在的
				return CommonResponse.success("选择的应用权限全部已存在");
			}
		}
		return CommonResponse.success("分配应用权限成功");
	}

	@Override
	public CommonResponse<String> delUserApp(List<UserManagerAppRelationVO> relationVO) {
		List<Long> appIds = new ArrayList<>();
		relationVO.forEach(e -> {
			appIds.add(e.getAppId());
		});
		QueryWrapper<UserManagerRelationAppEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("user_id", relationVO.get(0).getUserId());
		wrapper.in("app_id", appIds);
		wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		userManagerRelationMapper.delete(wrapper);
		return CommonResponse.success("删除成功");
	}

	@Override
	public IPage<AppEntity> queryUserApp(Map<String, Object> params) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
			long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
			params.put("startLine", startLine);
		}
		params.put("tenantId", InvocationInfoProxy.getTenantid());
		Long count = userManagerRelationMapper.countUserApp(params);
		IPage<AppEntity> page = new Page<AppEntity>();
		if(count>0){
			List<AppEntity> appEntity = userManagerRelationMapper.queryUserApp(params);
			page.setRecords(appEntity);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

}
