package com.ejianc.foundation.oms.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.foundation.oms.bean.ComboAppEntity;
import com.ejianc.foundation.permission.vo.AppVO;

/**
 * 套餐应用关系
 * 
 * @author generator
 * 
 */
@Mapper
public interface ComboAppMapper extends BaseCrudMapper<ComboAppEntity> {

    Long countByProPerties(Map<String, Object> queryParam);
    
    List<AppVO> queryPageByProperties(Map<String, Object> queryParam);

	void deleteAuthApp(@Param("comboId") Long comboId,@Param("appId") Long appId);

    Long countComboAppRefList(Map<String, Object> params);
    
    //获取套餐下（该套餐分配角色的）有权限（分配角色的应用+运营类的应用）的应用（套餐分配应用使用）
    List<AppVO> comboAppRefList(Map<String, Object> params);
    
    //判断某个应用除了在该套餐下是否还在该租户分配的其余套餐下存在
    Long exitAppNotComboId(@Param("comboId") Long comboId,@Param("appId") Long appId,@Param("tenantId") Long tenantId);
}
