package com.ejianc.foundation.workbench.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.WXEEConstant;
import com.ejianc.foundation.workbench.service.IWxeeThirdAppService;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.ejianc.foundation.utils.WXEEConstant.*;

/**
 * 企业微信第三方应用 服务接口
 *
 */
@Service
public class WxeeThirdAppService implements IWxeeThirdAppService, Serializable {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private static final long serialVersionUID = 1L;

    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private IEnterpriseService iEnterpriseService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IUserService iUserService;


    /**
     * 企业微信授权成功回调
     *
     * @param tpmAuthCode 临时授权码
     */
    @Override
    @Transactional
    public void openApp(String tpmAuthCode) {
        /** 第一步：获取suite_ticket */
        log.info("第一步：获取suite_ticket！");
        String suite_ticket = thirdSystemService.getThirdAppSuiteTicket(WXEEConstant.SUITEID,"wxee");
        if(StringUtils.isEmpty(suite_ticket)){
            log.info("缓存中suite_ticket为空！");
            throw new BusinessException("缓存中suite_ticket为空！");
        }
        /** 第二步：获取suite_access_token */
        log.info("第二步：获取suite_access_token！");
        JSONObject body = new JSONObject();
        body.put("suite_id",YJB_SUIT_ID);
        body.put("suite_secret",YJB_SECRET);
        body.put("suite_ticket",suite_ticket);
        String suite_access_token = thirdSystemService.getWXEESuiteAccessToken(body,YJB_SUIT_ID);

        /** 第三步：获取企业永久授权码 */
        log.info("第三步：获取企业永久授权码！");
        body = new JSONObject();
        body.put("auth_code",tpmAuthCode);
        JSONObject promiseCode = thirdSystemService.getWXEEPermanentCode(suite_access_token,body);
        log.info("获取的授权码信息：{}",promiseCode);
        /** 第四步：拼装企业信息，初始化操作 */
        log.info("第四步：拼装企业信息，初始化操作！");
        JSONObject auth_corp_info = promiseCode.getJSONObject("auth_corp_info");

        EnterpriseVO enterpriseVO = new EnterpriseVO();

        enterpriseVO.setComboCode("wxeeApp-init");
        enterpriseVO.setSourceFrom("wxee");
        enterpriseVO.setEnterpriseType("1");
        enterpriseVO.setBusinessType("1");
        enterpriseVO.setCommitTime(new Date());
        enterpriseVO.setAuditTime(new Date());
        enterpriseVO.setAuditName("系统生成！");
        enterpriseVO.setAuditOpinion("系统生成！通过！");
        enterpriseVO.setExamineState("1");
        enterpriseVO.setCode("WXEE-APP-"+auth_corp_info.getString("corpid"));
        enterpriseVO.setPermanentCode(promiseCode.getString("permanent_code"));
        enterpriseVO.setName(auth_corp_info.getString("corp_name"));
        enterpriseVO.setFullName(auth_corp_info.getString("corp_full_name"));
        enterpriseVO.setCorpid(auth_corp_info.getString("corpid"));
        enterpriseVO.setDescription("企业微信第三方应用开开通生成！");
        enterpriseVO.setWays("6");
        if(promiseCode.getJSONObject("auth_info") == null){
            log.info("永久授权码未返回auth_info信息！");
            throw new BusinessException("永久授权码未返回auth_info信息！");
        }
        JSONObject privilege = promiseCode.getJSONObject("auth_info").getJSONArray("agent").getJSONObject(0).getJSONObject("privilege");
        String[] userIds = new String[]{} ;
        if(privilege.getJSONArray("allow_user")!=null){
            userIds = privilege.getJSONArray("allow_user").toArray(new String[0]);
        }
        /** 第五步：获取应用对企业的access_token*/
        log.info("第五步：获取应用对企业的access_token！");
        body = new JSONObject();
        body.put("auth_corpid",auth_corp_info.getString("corpid"));
        body.put("permanent_code",promiseCode.getString("permanent_code"));
        String accessToken = promiseCode.getString("access_token");
        redisTemplate.opsForValue().set("EJB_corpid_AccessToken"+auth_corp_info.getString("corpid"),accessToken,7000, TimeUnit.SECONDS);
        /** 第六步：获取有权限的用户信息 */
        log.info("第六步：获取有权限的用户信息！");
        JSONArray userInfos = new JSONArray();
        Map<String,JSONObject> userMap = new HashMap<>();
        for (String userId : userIds) {
            JSONObject info = thirdSystemService.getWXEEUserInfo(accessToken,userId);
            userInfos.add(info);
            userMap.put(userId,info);
        }
        if(privilege.getJSONArray("allow_party")!=null){
            /** 第7步：获取授权部门下的成员用户*/
            log.info("第7步：获取授权部门下的成员用户！");
            String[] deptIds = privilege.getJSONArray("allow_party").toArray(new String[0]);
            for (String deptId : deptIds) {
                JSONArray userList = thirdSystemService.getWXEEDeptUserList(accessToken,deptId);
                if(userList!=null){
                    for (Object user : userList) {
                        JSONObject userInfo = (JSONObject) user;
                        if(userMap.get(userInfo.getString("userid")) == null){
                            JSONObject info = thirdSystemService.getWXEEUserInfo(accessToken,userInfo.getString("userid"));
                            userInfos.add(info);
                            userMap.put(userInfo.getString("userid"),info);
                        }
                    }
                }
            }
        }
        /** 第8步：拼装管理员用户信息
         *  首先，获取授权管理员信息设置为管理员
         *  否则取授权人员中第一个作为管理员
         * */
        log.info("第8步：拼装管理员用户信息！");
        JSONObject superUser = userInfos.getJSONObject(0);//默认取第一个作为超管
        JSONObject authUserInfo = promiseCode.getJSONObject("auth_user_info");
        if(authUserInfo!=null){
            enterpriseVO.setUserName(authUserInfo.getString("userid"));
            enterpriseVO.setUserCode(authUserInfo.getString("open_userid"));
            enterpriseVO.setUserSourceId(authUserInfo.getString("userid"));
        }else {
            enterpriseVO.setUserName(superUser.getString("name"));
            enterpriseVO.setTelephone(superUser.getString("mobile"));
            enterpriseVO.setUserCode(superUser.getString("open_userid"));
            enterpriseVO.setUserSourceId(superUser.getString("userid"));
        }
        /** 第八步：初始化企业、租户、超管等等 */
        log.info("第八步：初始化企业、租户、超管等等！");
        iEnterpriseService.initData(enterpriseVO);
        log.info("第八步：初始化企业、租户、超管等等！-------完成！");

        /** 第十步：将用户持久化 */
        log.info("第十步：将用户持久化！");
        for (Object user : userInfos) {
            JSONObject userInfo = (JSONObject) user;
            iUserService.initThirdAppUsers(userInfo.getString("userid"),userInfo.getString("name"),userInfo.getString("mobile"),userInfo.getString("open_userid"),enterpriseVO.getTenantId(),"WXEETHIRDAPP-INIT");
        }
        log.info("第十步：将用户持久化！-------完成！");
    }

    /**
     * 企业微信授权 变更回调
     *
     * @param authCorpId 授权企业id
     * @param suiteId    应用id
     */
    @Override
    @Transactional
    public void changeAuth(String authCorpId, String suiteId) {
        /** 第一步：获取企业永久授权码 */
        log.info("企业微信授权 变更回调 第一步：获取 企业永久授权码！--- authCorpId "+authCorpId+"  suiteId = "+ suiteId);
        String promiseCode = thirdSystemService.getTenantPromiseCode(authCorpId);
        if(StringUtils.isEmpty(promiseCode)){
            log.info("企业微信授权 变更回调！企业永久授权码为空！");
            return;
        }
        /** 第2步：获取suite_ticket */
        log.info("第2步：获取suite_ticket！");
        String suite_ticket = thirdSystemService.getThirdAppSuiteTicket(WXEEConstant.SUITEID,"wxee");
        if(StringUtils.isEmpty(suite_ticket)){
            log.info("企业微信授权 变更回调  缓存中suite_ticket为空！");
            return;
        }
        /** 第3步：获取suite_access_token */
        log.info("第3步：获取suite_access_token！");
        JSONObject body = new JSONObject();
        body.put("suite_id",YJB_SUIT_ID);
        body.put("suite_secret",YJB_SECRET);
        body.put("suite_ticket",suite_ticket);
        String suite_access_token = thirdSystemService.getWXEESuiteAccessToken(body,YJB_SUIT_ID);
        body = new JSONObject();
        body.put("auth_corpid",authCorpId);
        body.put("permanent_code",promiseCode);
        /** 第4步：授权信息 */
        log.info("第4步：获取授权信息！");
        JSONObject authInfo = thirdSystemService.getWXEEAuthInfo(suite_access_token,body);
        JSONObject privilege = authInfo.getJSONObject("auth_info").getJSONArray("agent").getJSONObject(0).getJSONObject("privilege");
        String[] userIds = new String[]{} ;
        if(privilege.getJSONArray("allow_user")!=null){
            userIds = privilege.getJSONArray("allow_user").toArray(new String[0]);
        }
        String[] deptIds = new String[]{} ;
        if(privilege.getJSONArray("allow_party")!=null){
            StringBuilder ids = new StringBuilder();
            for (Object allowParty : privilege.getJSONArray("allow_party")) {
                ids.append(allowParty).append(",");
            }
            deptIds = ids.toString().split(",");
        }
        JSONArray userInfos = new JSONArray();
        Map<String,JSONObject> userMap = new HashMap<>();
        body = new JSONObject();
        body.put("auth_corpid",authCorpId);
        body.put("permanent_code",promiseCode);
        /** 第5步：accessToken */
        log.info("第5步：获取企业 accessToken！");
        String accessToken = thirdSystemService.getWXEECorpToken(authCorpId,suite_access_token,body);
        /** 第6步：人员信息 */
        log.info("第6步：获取 人员信息！");
        for (String userId : userIds) {
            if(StringUtils.isNotEmpty(userId)){
                JSONObject info = thirdSystemService.getWXEEUserInfo(accessToken,userId);
                userInfos.add(info);
                userMap.put(userId,info);
            }
        }
        /** 第7步：根据授权部门获取其下授权人员信息 */
        log.info("第7步：根据授权部门获取其下授权人员信息 ！");
        for (String deptId : deptIds) {
            if(StringUtils.isNotEmpty(deptId)){
                JSONArray userList = thirdSystemService.getWXEEDeptUserList(accessToken,deptId);
                if(userList!=null){
                    for (Object user : userList) {
                        JSONObject userInfo = (JSONObject) user;
                        if(userMap.get(userInfo.getString("userid")) == null){
                            JSONObject info = thirdSystemService.getWXEEUserInfo(accessToken,userInfo.getString("userid"));
                            userInfos.add(info);
                            userMap.put(userInfo.getString("userid"),info);
                        }
                    }
                }
            }
        }
        /** 第8步：根据企业id，查询租户信息 */
        log.info("第8步：根据企业id，查询租户信息 ！");
        TenantEntity tenantEntity = thirdSystemService.getTenantByThirdCorpid(authCorpId);
        /** 第9步：将用户持久化 */
        log.info("第9步：将用户持久化 ！");
        for (Object user : userInfos) {
            JSONObject userInfo = (JSONObject) user;
            log.info(userInfo.toJSONString());
            iUserService.initThirdAppUsers(userInfo.getString("userid"),userInfo.getString("name"),userInfo.getString("mobile"),userInfo.getString("open_userid"),tenantEntity.getId(),"WXEETHIRDAPP-INIT");
        }
        log.info("第9步：将用户持久化！-------完成！");
    }

    /**
     * 通讯录变更事件通知 新增成员
     *
     * @param authCorpId 授权企业id
     * @param suiteId    应用id
     * @param userId
     * @param openUserID
     * @param mobile
     */
    @Override
    public void addUser(String authCorpId, String suiteId, String userId, String openUserID, String mobile) {
        /** 第一步：获取企业永久授权码 */
        log.info("通讯录变更事件通知 新增成员 第一步：根据企业id，查询租户信息 ！--- authCorpId "+authCorpId);
        TenantEntity tenantEntity = thirdSystemService.getTenantByThirdCorpid(authCorpId);
        /** 第9步：将用户持久化 */
        log.info("第2步：将用户持久化 ！");
        iUserService.initThirdAppUsers(userId,userId,mobile,openUserID,tenantEntity.getId(),"WXEETHIRDAPP-INIT");
        log.info("第2步：将用户持久化！-------完成！");
    }

    /**
     * 通讯录变更事件通知 修改成员
     *
     * @param authCorpId 授权企业id
     * @param suiteId    应用id
     * @param oldUserId
     * @param newUserId
     * @param openUserID
     * @param mobile
     */
    @Override
    public void changeUser(String authCorpId, String suiteId, String oldUserId, String newUserId, String openUserID, String mobile,Integer state) {
        TenantEntity tenantEntity = thirdSystemService.getTenantByThirdCorpid(authCorpId);
        UserVO userVO = iUserService.queryUserBySourceId(oldUserId,tenantEntity.getId());
        if(userVO != null){
            if(StringUtils.isNotEmpty(newUserId) && !newUserId.equals(oldUserId)){
                userVO.setSourceId(newUserId);
                userVO.setUserName(newUserId);
            }
            userVO.setUserMobile(mobile);
            iUserService.updateThirdAppUsers(userVO,state);
        }
    }
}
