/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.element.visitor;

import com.ejianc.foundation.workbench.element.node.Cell;
import com.ejianc.foundation.workbench.element.node.Container;
import com.ejianc.foundation.workbench.element.node.Element;
import com.ejianc.foundation.workbench.element.node.WidgetBox;
import com.ejianc.foundation.workbench.element.visitor.CellVisitor;
import com.ejianc.foundation.workbench.element.visitor.ContainerVisitor;
import com.ejianc.foundation.workbench.element.visitor.WidgetBoxVisitor;
import java.io.IOException;

public class ElementVisitor {
    private Appendable accumulation;
    private ContainerVisitor containerVisitor;
    private CellVisitor cellVisitor;
    private WidgetBoxVisitor widgetBoxVisitor;

    public ElementVisitor(Appendable accumulation) {
        this.accumulation = accumulation;
        this.containerVisitor = new ContainerVisitor();
        this.cellVisitor = new CellVisitor();
        this.widgetBoxVisitor = new WidgetBoxVisitor();
    }

    public void head(Element element) throws IOException {
        if (element instanceof Container) {
            this.containerVisitor.head((Container)element, this.accumulation);
        }
        if (element instanceof Cell) {
            this.cellVisitor.head((Cell)element, this.accumulation);
        }
        if (element instanceof WidgetBox) {
            this.widgetBoxVisitor.head((WidgetBox)element, this.accumulation);
        }
    }

    public void tail(Element element) throws IOException {
        if (element instanceof Container) {
            this.containerVisitor.tail((Container)element, this.accumulation);
        }
        if (element instanceof Cell) {
            this.cellVisitor.tail((Cell)element, this.accumulation);
        }
        if (element instanceof WidgetBox) {
            this.widgetBoxVisitor.tail((WidgetBox)element, this.accumulation);
        }
    }
}

