package com.ejianc.foundation.orgcenter.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.utils.gdty.param.GdtyOrg;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface OrgMapper extends BaseCrudMapper<OrgEntity> {

	List<OrgVO> queryOrgList(Map<String, Object> condition);
	//查询组织部门树时，之前的无法判断该节点是否是叶子节点，故作处理
	List<OrgVO> queryOrgList2(Map<String, Object> condition);

	List<OrgVO> getSubOrgs(@Param("orgId") Long orgId,@Param("prjstate") Integer prjstate);

	List<OrgVO> queryUserContextOrgList(@Param("tenantId") Long tenantId, @Param("orgIds") String orgIds,@Param("prjstate") Integer prjstate);

	List<OrgVO> queryJobOrgsByUserId(@Param("userId") Long userId, @Param("tenantId") Long tenantId);

	List<OrgVO> queryAppSubByPid(@Param("innerCode") String innerCode);

	List<OrgVO> queryParentsByOrgId(@Param("innerCode") String innerCode);
	
	List<OrgVO> queryParentsByOrgIdAsc(@Param("innerCode") String innerCode);

	List<OrgVO> queryOrgListByIds(@Param("orgIds") String orgIds);

	List<OrgVO> queryAllProjectOrgsByInnerCode(@Param("innerCode") String innerCode);

	List<OrgVO> queryAllOrgByInnerCodeWithoutProjectDept(@Param("innerCode") String innerCode);

    List<Map<String, Object>> getSubOrgMaps(@Param("orgId") Long orgId);

    List<Map<String, Object>> findOrgMapsByTenantId(@Param("tenantId") Long tenantId);

	void insertGdtyOrgData(@Param("insertOrgSql") String insertOrgSql);

	List<GdtyOrg> queryGdtyOrgData();

	List<OrgVO> queryOrgNewList(Map<String, Object> params);

	List<OrgVO> searchOrgs(@Param("searchText") String searchText,@Param("innerCode") String innerCode,@Param("prjstate") Integer prjstate);
}
