package com.ejianc.foundation.orgcenter.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 部门service
 * 
 * @author guominga
 *
 */
public interface IDeptService extends IBaseService<DeptEntity> {

	/**
	 * 新增或修改
	 * 
	 * @param deptVo
	 * @param b
	 * @return
	 */
	CommonResponse<String> save(DeptVO deptVo);

	CommonResponse<String> delete(List<Long> ids);

	JSONObject checkQuote(Long sourceOrgId, Long targetOrgId);

	CommonResponse<String> quoteDept(Map<String, Object> params);

    DeptEntity selectById(Long deptId);

	/**
	 * 根据主键Id列表查询对应的部门信息列表
	 *
	 * @param deptIds
	 * @return
	 */
    List<DeptEntity> getAllByIds(List<Long> deptIds);

	List<DeptVO> queryDeptList(Map<String, Object> param);

	IPage<JSONObject> queryDeptUser(Integer pageNumber,
									Integer pageSize,
									String condition,
									String searchObject,
									String searchText);
}
