package com.ejianc.foundation.permission.bean;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 *
 *  单据查询权限
 *
 *  租户级别，按单据类型配置，默认所有人可查看，所有人可编辑
 *
 * */

@TableName("ejc_idm_bill_purview")
public class BillPurviewEntity  extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_type_id")
    private Long billTypeId;// 单据类型Id

    @TableField(value = "bill_type_code")
    private String billTypeCode;// 单据类型编码

    @TableField(value = "bill_type_name")
    private String billTypeName;// 单据类型名称

    @TableField(value = "view_self")
    private Boolean viewSelf;// true 仅制单人可查看，false  所有人可查看  默认false

    @TableField(value = "edit_all")
    private Boolean editAll;// true 所有人可编辑，false  仅制单人可编辑

    @TableField(value = "role_ids")
    private String roleIds;// 仅制单人查看时，白名单角色也可查看

    @TableField(value = "role_names")
    private String roleNames;// 仅制单人查看时，白名单角色也可查看

    public Long getBillTypeId() {
        return billTypeId;
    }

    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public Boolean getViewSelf() {
        return viewSelf;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public void setViewSelf(Boolean viewSelf) {
        this.viewSelf = viewSelf;
    }

    public Boolean getEditAll() {
        return editAll;
    }

    public void setEditAll(Boolean editAll) {
        this.editAll = editAll;
    }

    public String getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(String roleIds) {
        this.roleIds = roleIds;
    }

    public String getRoleNames() {
        return roleNames;
    }

    public void setRoleNames(String roleNames) {
        this.roleNames = roleNames;
    }
}
