package com.ejianc.foundation.usercenter.service.impl;

import org.springframework.stereotype.Service;
import org.springside.modules.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.usercenter.bean.UserThirdSystemEntity;
import com.ejianc.foundation.usercenter.mapper.UserThirdSystemMapper;
import com.ejianc.foundation.usercenter.service.IUserThirdSystemService;
import com.ejianc.foundation.usercenter.vo.UserThirdSystemVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class UserThirdSystemServiceImpl extends BaseServiceImpl<UserThirdSystemMapper, UserThirdSystemEntity>
		implements IUserThirdSystemService {

	@Override
	public UserThirdSystemEntity queryByUserNameAndPassword(String loginName, String password, Long systemId) {
		QueryWrapper<UserThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("target_user_code", loginName);
		queryWrapper.eq("target_user_password", password);
		queryWrapper.eq("third_system_id", systemId);
		UserThirdSystemEntity entity = super.getOne(queryWrapper);
		return entity;
	}

	@Override
	public UserThirdSystemVO getExtUser(Long thirdSystemId, Long userId) {
		QueryWrapper<UserThirdSystemEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("user_id", userId);
		queryWrapper.eq("third_system_id", thirdSystemId);
		UserThirdSystemEntity entity = super.getOne(queryWrapper);
		if(entity != null) {
			return BeanMapper.map(entity, UserThirdSystemVO.class);
		}
		return null;
	}

}
