package com.ejianc.foundation.workbench.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.service.impl.TenantMenuServiceImpl;
import com.ejianc.foundation.workbench.bean.MenuCategoryEntity;
import com.ejianc.foundation.workbench.bean.MenuEntity;
import com.ejianc.foundation.workbench.mapper.MenuCategoryMapper;
import com.ejianc.foundation.workbench.service.IMenuCategoryService;
import com.ejianc.foundation.workbench.service.IMenuService;
import com.ejianc.foundation.workbench.vo.MenuCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class MenuCategoryServiceImpl extends BaseServiceImpl<MenuCategoryMapper, MenuCategoryEntity> implements IMenuCategoryService {

	private final static Logger LOGGER = LoggerFactory.getLogger(TenantMenuServiceImpl.class);
	private static final String MENU_CATEGORY_BILL_CODE = "IDM_MENU_CATEGORY";
	private static final String MENU_BILL_CODE = "IDM_MENU";

	@Autowired
	private MenuCategoryMapper menuCategoryMapper;
	@Autowired
	private IMenuService menuItemService;
	@Autowired
	private IBillCodeApi billCodeApi;

	@Override
	public CommonResponse<MenuCategoryVO> copy(MenuCategoryVO saveOrUpdateVO) {
		if(saveOrUpdateVO.getCopyId()==null){
			throw new BusinessException("未获取到要复制的分类，请重新选择");
		}
		MenuCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, MenuCategoryEntity.class);
		if(entity.getId() == null || entity.getId() == 0){
			if(StringUtils.isBlank(saveOrUpdateVO.getCode())) {
				CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(MENU_CATEGORY_BILL_CODE, InvocationInfoProxy.getTenantid());
				if (billCode.isSuccess()) {
					entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				} else {
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
			}
		}
		this.saveOrUpdate(entity, false);
		MenuCategoryVO vo = BeanMapper.map(entity, MenuCategoryVO.class);

		//获取菜单数据
		QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("menu_category_id", saveOrUpdateVO.getCopyId());
		wrapper.eq("tenant_id", 999999l);
		List<MenuEntity> menuList = menuItemService.list(wrapper);
		if(menuList!=null && menuList.size()>0){
			menuList = this.createTreeData(menuList);
			Map<Long, String> innerCodeMap = new HashMap<>();
			this.dealInnerCode(menuList, innerCodeMap, null);
			List<MenuEntity> entitys = new ArrayList<>();
			this.dealMenu(entitys, menuList);
			CommonResponse<List<String>> menuResponse = billCodeApi.getCodeBatchByRuleCode(MENU_BILL_CODE, 999999l, entitys.size());
			for(int i=0; i<entitys.size(); i++){
				List<String> codeResponse = menuResponse.getData();
				MenuEntity en = entitys.get(i);
				en.setMenuCategoryId(entity.getId());
				en.setCode(codeResponse.get(i));
			}
			menuItemService.saveOrUpdateBatch(entitys, entitys.size(), false);
		}
		return CommonResponse.success("保存或修改单据成功！",vo);
	}

	private void dealMenu(List<MenuEntity> result, List<MenuEntity> entitys){
		for(MenuEntity entity : entitys){
			result.add(entity);
			if(entity.getChildren()!=null && entity.getChildren().size()>0){
				this.dealMenu(result, entity.getChildren());
			}
		}
	}

	private void dealInnerCode(List<MenuEntity> vos, Map<Long, String> innerCodeMap, Long pid){
		for (MenuEntity vo : vos){
			vo.setId(IdWorker.getId());
			vo.setParentId(pid);
			if(vo.getParentId() == null){
				vo.setInnerCode(vo.getId().toString());
				//根节点的数据
				innerCodeMap.put(vo.getId(), vo.getId().toString());
			}else{
				String parentInnerCode = innerCodeMap.get(vo.getParentId());
				if(StringUtils.isNotBlank(parentInnerCode)){
					String innercode = parentInnerCode + "|" + vo.getId().toString();
					innerCodeMap.put(vo.getId(), innercode);
				}else{
					innerCodeMap.put(vo.getId(), vo.getId().toString());
				}
			}

			if(vo.getChildren()!=null && vo.getChildren().size()>0){
				this.dealInnerCode(vo.getChildren(), innerCodeMap, vo.getId());
			}
		}
	}

	public List<MenuEntity> createTreeData(List<MenuEntity> list) {
		List<MenuEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, MenuEntity> listMap = new HashMap<>();
		for(MenuEntity menuEntity:list) {
			listMap.put(menuEntity.getId().toString(), menuEntity);
		}

		for(int i =0; i<list.size(); i++) {
			MenuEntity menuEntity = list.get(i);
			String parentId = (menuEntity.getParentId() != null && menuEntity.getParentId() > 0) ? menuEntity.getParentId().toString():"";
			MenuEntity parent = listMap.get(parentId);
			if(parent != null) {
				List<MenuEntity> child = parent.getChildren();
				if(child != null) {
					child.add(menuEntity);
				}else{
					List<MenuEntity> children = new ArrayList<MenuEntity>();
					children.add(menuEntity);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(menuEntity.getId().toString());
			}
		}

		for(String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
