package com.ejianc.foundation.workbench.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponse;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teautil.models.RuntimeOptions;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.*;
import com.dingtalk.api.response.*;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.DdConstant;
import com.ejianc.foundation.workbench.service.IDdThirdAppService;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.taobao.api.ApiException;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;

@Service
public class DdThirdAppServiceImpl implements IDdThirdAppService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IDefaultpwdService iDefaultpwdService;
    @Autowired
    private IEnterpriseService enterpriseService;
    @Autowired
    private RedissonLocker redissonLocker;

    @Override
    public void openApp(JSONObject data) {
        //判断企业是否开通，开通了执行企业授权变更；没有开通先进行企业授权
        String corpid = data.getString("corp_id");//授权方企业id
        JSONObject biz_data = JSON.parseObject(data.getString("biz_data"));
        JSONObject auth_scope = JSON.parseObject(biz_data.getString("auth_scope"));
        String auth_org_scopes = auth_scope.getString("auth_org_scopes");
        //获取企业id
        JSONObject auth_corp_info = JSON.parseObject(biz_data.getString("auth_corp_info"));

        try {
            redissonLocker.lock("ddThirdApp-initTenant-" + corpid, TimeUnit.MICROSECONDS, 10);
            //获取当前租户信息
            QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
            tenantWrapper.eq("dr", 0);
            tenantWrapper.eq("corpid", corpid);
            TenantEntity tenantEntity = tenantService.getOne(tenantWrapper);

            String suiteTicket = thirdSystemService.getThirdAppSuiteTicket(DdConstant.SUITEID, "ddThirdApp");
            String accessToken = thirdSystemService.getDdThirdAppAccessToken(corpid, suiteTicket);

            if (tenantEntity == null) {
                //没有开通先进行企业授权
                EnterpriseVO enterpriseVO = new EnterpriseVO();
                enterpriseVO.setComboCode("ddApp-init");
                enterpriseVO.setCorpid(corpid);
                enterpriseVO.setName(auth_corp_info.getString("corp_name"));
                JSONObject auth_user_info = JSON.parseObject(biz_data.getString("auth_user_info"));
                String userId = auth_user_info.getString("userId");
                //获取超级管理员信息
                JSONObject userInfo = getUserInfoById(userId, accessToken);
                enterpriseVO.setUserSourceId(userId);
                enterpriseVO.setUserName(userInfo.getString("name"));
                enterpriseVO.setLegalName(userInfo.getString("name"));
                String mobile = userInfo.get("mobile") != null && userInfo.getString("mobile") != "" ? userInfo.getString("mobile") : userInfo.getString("userid");
//            String job_number = userInfo.get("job_number")!=null&&userInfo.getString("job_number")!=""?userInfo.getString("job_number"):userInfo.getString("userid");
                enterpriseVO.setUserCode(userId);
                enterpriseVO.setTelephone(mobile);
                enterpriseVO.setSourceFrom("ddThirdApp");
                enterpriseService.initData(enterpriseVO);

                //新增普通管理员
                JSONObject auth_info = JSON.parseObject(biz_data.getString("auth_info"));
                JSONArray agent = JSON.parseArray(auth_info.getString("agent"));
                if (agent != null && agent.size() > 0) {
                    for (Object item : agent) {
                        JSONObject info = JSONObject.parseObject(item.toString());
                        if (DdConstant.APPID.equals(info.getString("appid"))) {
                            //益建宝应用
                            JSONArray admin_list = JSON.parseArray(info.getString("admin_list"));
                            for (Object admin : admin_list) {
                                if (!userId.equals(admin.toString())) {
                                    JSONObject user = getUserInfoById(admin.toString(), accessToken);
                                    user.put("corp_id", corpid);
                                    saveUser(user, 3);
                                }
                            }

                        }
                    }
                }

            }
            //进行企业授权信息变更
            this.changeAuthUser(auth_org_scopes, corpid, accessToken);
        } catch (Exception e) {
        } finally {
            redissonLocker.unlock("ddThirdApp-initTenant-" + corpid);
        }

    }

    @Override
    public void changeAuthUser(String authOrgScopes, String corpid, String accessToken) {
        JSONObject data = JSON.parseObject(authOrgScopes);
        List<String> users = JSONArray.parseArray(data.getString("authed_user"),String.class);
        List<String> depts = JSONArray.parseArray(data.getString("authed_dept"),String.class);
        List<Long> deptIds = new ArrayList<>();
        //获取当前租户信息
        QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
        tenantWrapper.eq("dr", 0);
        tenantWrapper.eq("corpid", corpid);
        TenantEntity tenantEntity = tenantService.getOne(tenantWrapper);
        //获取当前租户组织信息
        OrgVO orgVO = orgService.findOrgByTenantId(tenantEntity.getId());
        if(StringUtils.isBlank(accessToken)){
            String suiteTicket = thirdSystemService.getThirdAppSuiteTicket(DdConstant.SUITEID,"ddThirdApp");
            accessToken = thirdSystemService.getDdThirdAppAccessToken(corpid, suiteTicket);
        }
        logger.info("accessToken---------------"+accessToken);
        //1、获取所有有权限的用户id
        if(depts!=null&&depts.size()>0){
            for(String deptId : depts){
                deptIds.add(Long.parseLong(deptId));
                deptIds = getDeptList(Long.parseLong(deptId), accessToken, deptIds);
            }
            logger.info("授权的部门id-----"+deptIds.toString());
            for(Long deptId : deptIds){
                users = getUsersIdByDeptId(deptId, accessToken, users);
            }
        }
        logger.info("授权的用户id-----"+users.toString());

        //2、获取存在当前系统中的用户id，
        //2.1、获取存在当前租户中但是已被停用的的用户id，启用用户
        List<String> disableUsers = userService.selectSourceIds(users, tenantEntity.getId(), "disabled");
        new Thread(() ->{
            logger.info("myThread1-----");
            if(disableUsers!=null && disableUsers.size()>0){
                for(String sourceId : disableUsers){
                    QueryWrapper<EmployeeEntity> employeeWrapper = new QueryWrapper<>();
                    employeeWrapper.eq("dr", 0);
                    employeeWrapper.eq("source_id", sourceId);
                    EmployeeEntity enployeeEntity = employeeService.getOne(employeeWrapper);
                    EmployeeVO employeeVO = BeanMapper.map(enployeeEntity, EmployeeVO.class);
                    employeeVO.setTenantId(tenantEntity.getTenantId());
                    employeeVO.setState(1);
                    employeeService.enabledEmployeeState(employeeVO);
                }
            }
        },"myThread1").start();

        //2.2、获取存在系统中但是不存在当前租户中的用户id，并建立租户用户关系
        List<String> exitOtherUsers = userService.selectSourceIds(users, tenantEntity.getId(), "exitOther");
        new Thread(() ->{
            logger.info("myThread2-----");
            if(exitOtherUsers!=null && exitOtherUsers.size()>0){
                for(String userId : exitOtherUsers){
                    UserVO userVO = userService.queryUserBySourceId(userId,tenantEntity.getId());
                    //生成用户租户关系
                    UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
                    userTenantRelationEntity.setMainSpaceFlag(0);
                    userTenantRelationEntity.setUserId(userVO.getId());
                    userTenantRelationEntity.setTenantId(tenantEntity.getId());
                    userTenantRelationEntity.setTypeId(2);
                    userTenantRelationEntity.setEmployeeId(userVO.getId());
                    userTenantRelationEntity.setOrgId(orgVO.getId());
                    userTenantRelationEntity.setState(1);
                    userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
                }
            }
        },"myThread2").start();

        //3、获取不存在当前系统中的用户id，新增用户
        //3.1、获取存在当前系统的中的用户id，和原数据比较，取互斥值
        List<String> exitUsers = userService.selectSourceIds(users, null, "exit");
        if(exitUsers!=null&&exitUsers.size()>0){
            List<String> noExitUsers = new ArrayList<>();
            for(String userId : users){
                if(!exitUsers.contains(userId)){
                    noExitUsers.add(userId);
                }
            }
            //3.2、新增
            String finalAccessToken = accessToken;
            new Thread(() ->{
                logger.info("myThread3-----");
                if(noExitUsers!=null&&noExitUsers.size()>0){
                    for(String userId : noExitUsers){
                        JSONObject userInfo = getUserInfoById(userId, finalAccessToken);
                        addUser(userInfo, tenantEntity.getId(), orgVO.getId(), 2);
                    }
                }
            },"myThread3").start();
        }

        //4、获取不在当前传入的用户id但在系统中的用户，停用
        List<String> toDisableUsers = userService.selectSourceIds(users, tenantEntity.getId(), "toDisabled");
        new Thread(() ->{
            logger.info("myThread4-----");
            if(toDisableUsers!=null&&toDisableUsers.size()>0){
                for(String sourceId : toDisableUsers){
                    QueryWrapper<EmployeeEntity> employeeWrapper = new QueryWrapper<>();
                    employeeWrapper.eq("dr", 0);
                    employeeWrapper.eq("source_id", sourceId);
                    EmployeeEntity enployeeEntity = employeeService.getOne(employeeWrapper);
                    EmployeeVO employeeVO = BeanMapper.map(enployeeEntity, EmployeeVO.class);
                    employeeVO.setTenantId(tenantEntity.getTenantId());
                    employeeVO.setState(0);
                    employeeService.enabledEmployeeState(employeeVO);
                }
            }
        },"myThread4").start();

    }

    @Override
    public CommonResponse<String> syncUser(Long tenantId) {
        TenantEntity tenantEntity = tenantService.getById(tenantId);
        String corpid = tenantEntity.getCorpid();
        String suiteTicket = thirdSystemService.getThirdAppSuiteTicket(DdConstant.SUITEID,"ddThirdApp");
        String accessToken = thirdSystemService.getDdThirdAppAccessToken(corpid, suiteTicket);
        //获取授权部门、用户信息
        try{
            DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_AUTH_LIST);
            OapiAuthScopesRequest req = new OapiAuthScopesRequest();
            req.setHttpMethod("GET");
            OapiAuthScopesResponse rsp = client.execute(req, accessToken);
            JSONObject body = JSON.parseObject(rsp.getBody());
            changeAuthUser(body.getString("auth_org_scopes"), corpid, accessToken);
        }catch (Exception e){
            throw  new BusinessException("同步人员失败！");
        }

        return CommonResponse.success("同步人员成功");
    }

    @Override
    public void saveUser(JSONObject biz_data, Integer typeId) {
        String userid = biz_data.getString("userid");
        String jobnumber = biz_data.getString("jobnumber");
        String name = biz_data.getString("name");
        String corpid = biz_data.getString("corp_id");
        UserVO userVO = userService.queryUserByIdOrSourceId(userid);
        if(userVO!=null){
            //修改用户
            if(!name.equals(userVO.getUserName())){
                UserEntity entity = BeanMapper.map(userVO, UserEntity.class);
                entity.setUserName(name);
                EmployeeEntity employeeEntity = employeeService.selectById(userVO.getId());
                employeeEntity.setName(name);
                userService.saveOrUpdate(entity, false);
                employeeService.saveOrUpdate(employeeEntity, false);
            }
        }else{
            //新增用户
            //获取当前租户信息
            QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
            tenantWrapper.eq("dr", 0);
            tenantWrapper.eq("corpid", corpid);
            TenantEntity tenantEntity = tenantService.getOne(tenantWrapper);
            //获取当前租户组织信息
            OrgVO orgVO = orgService.findOrgByTenantId(tenantEntity.getId());
            JSONObject userInfo = new JSONObject();
            userInfo.put("userid", userid);
            userInfo.put("name", name);
            userInfo.put("job_number", jobnumber);
            userInfo.put("mobile", userid);
            addUser(userInfo, tenantEntity.getId(), orgVO.getId(), typeId);
        }
    }

    @Override
    public void delUser(String biz_id, String corpid) {
        //获取当前租户信息
        QueryWrapper<TenantEntity> tenantWrapper = new QueryWrapper<>();
        tenantWrapper.eq("dr", 0);
        tenantWrapper.eq("corpid", corpid);
        TenantEntity tenantEntity = tenantService.getOne(tenantWrapper);
        InvocationInfoProxy.setTenantid(tenantEntity.getId());

        QueryWrapper<EmployeeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("source_id", biz_id);
        wrapper.eq("tenant_id", tenantEntity.getId());
        EmployeeEntity employeeEntity = employeeService.getOne(wrapper);
        if(employeeEntity!=null){
            employeeService.deleteEmployee(BeanMapper.map(employeeEntity, EmployeeVO.class));
        }

    }

    /**
     * 获取部门列表
     */
    public List<Long> getDeptList(Long deptId, String accessToken, List<Long> deptIds) {
        try {
            DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_DEPT_LIST);
            OapiV2DepartmentListsubRequest req = new OapiV2DepartmentListsubRequest();
            if(deptId!=null){
                req.setDeptId(deptId);
            }
            OapiV2DepartmentListsubResponse rsp = client.execute(req, accessToken);
            JSONObject body = JSONObject.parseObject(rsp.getBody());
            JSONArray result = JSONArray.parseArray(body.getString("result"));
            logger.info("获取下级部门信息--------"+body.toJSONString());
            if(result!=null&&result.size()>0){
                for(Object json : result){
                    JSONObject item = JSON.parseObject(json.toString());
                    Long dept_id = Long.parseLong(item.getString("dept_id"));
                    if(!deptIds.contains(dept_id)){
                        deptIds.add(dept_id);
                        getDeptList(dept_id, accessToken, deptIds);
                    }
                }
            }
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return deptIds;
    }

    /**
     * 根据部门获取用户ids
     */
    public List<String> getUsersIdByDeptId(Long deptId, String accessToken, List<String> userIds) {
        try {
            logger.info("部门deptId--------->"+deptId);
            DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_DEPT_USER_LIST);
            OapiUserListidRequest req = new OapiUserListidRequest();
            req.setDeptId(deptId);
            OapiUserListidResponse rsp = client.execute(req, accessToken);
            JSONObject body = JSONObject.parseObject(rsp.getBody());
            logger.info("获取部门下人员信息--------->"+body.toJSONString());
            JSONObject result = JSONObject.parseObject(body.getString("result"));
            JSONArray list = JSONArray.parseArray(result.getString("userid_list"));
            if(list!=null&&list.size()>0){
                list.forEach(item -> {
                    String userId = item.toString();
                    if(!userIds.contains(userId)){
                        userIds.add(userId);
                    }
                });
            }
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return userIds;
    }

    /**
     * 查询用户详情
     */
    public JSONObject getUserInfoById(String userid, String accessToken) {
        try {
            logger.info("userid----------"+userid);
            DingTalkClient client = new DefaultDingTalkClient(DdConstant.GET_USERINFO);
            OapiV2UserGetRequest req = new OapiV2UserGetRequest();
            req.setUserid(userid);
            OapiV2UserGetResponse rsp = client.execute(req, accessToken);
            JSONObject body = JSONObject.parseObject(rsp.getBody());
            JSONObject result = JSONObject.parseObject(body.getString("result"));
            logger.info("第一次获取userInfo----------"+result.toJSONString());
//            String unionid = result.getString("unionid");
//            String job_number = result.getString("job_number");
//            result.put("name", unionid);
//            result.put("mobile", unionid);
            return result;
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return null;
    }

    public JSONObject getUserInfoByUnionId(String userid, String job_number, String unionId, String accessToken) {
        try {
            logger.info("unionId----------"+unionId);
            com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config();
            config.protocol = "https";
            config.regionId = "central";
            com.aliyun.dingtalkcontact_1_0.Client client = new com.aliyun.dingtalkcontact_1_0.Client(config);
            com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders getUserHeaders = new com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders();
            getUserHeaders.xAcsDingtalkAccessToken = accessToken;
            GetUserResponse rsp = client.getUserWithOptions(unionId, getUserHeaders, new RuntimeOptions());
            GetUserResponseBody body = rsp.getBody();
            JSONObject result = new JSONObject();
            result.put("name", body.getNick());
            result.put("mobile", body.getMobile());
            result.put("job_number", job_number);
            result.put("userid", userid);
            logger.info("最终结果userInfo----------"+result);

            return result;
        } catch (TeaException err) {
            if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
                // err 中含有 code 和 message 属性，可帮助开发定位问题
            }

        } catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), _err);
            if (!com.aliyun.teautil.Common.empty(err.code) && !com.aliyun.teautil.Common.empty(err.message)) {
                // err 中含有 code 和 message 属性，可帮助开发定位问题
            }

        }
        return null;
    }

    public void addUser(JSONObject userInfo, Long tenantId, Long orgId, Integer typeId){
        try{
            String mobile = userInfo.get("mobile")!=null&&userInfo.getString("mobile")!=""?userInfo.getString("mobile"):userInfo.getString("userid");
//            String job_number = userInfo.get("job_number")!=null&&userInfo.getString("job_number")!=""?userInfo.getString("job_number"):userInfo.getString("userid");

            UserVO userVO = new UserVO();
            userVO.setId(IdWorker.getId());
            userVO.setUserName(userInfo.getString("name"));
            userVO.setSourceId(userInfo.getString("userid"));
            userVO.setUserMobile(mobile);
            userVO.setTenantId(tenantId);
            DefaultPwdEntity defaultPwdEntity = iDefaultpwdService.getUserDefaultPassword(tenantId);
            PasswordUtils.setSalt(userVO);
            String password = defaultPwdEntity.getDefaultpwd();
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            userVO.setEmployeeId(userVO.getId());

            userVO.setUserCode(userInfo.getString("userid"));
            userVO.setUserState(UserVO.USER_STATE_ACTIVE); //启用状态
            userVO.setTypeId(typeId!=null?typeId:2); //普通员工
            userVO.setDr(BaseVO.DR_UNDELETE);
            userVO.setOrgId(orgId);

            //2、生成租户与用户之间的关系
            UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
            userTenantRelationEntity.setMainSpaceFlag(1);
            userTenantRelationEntity.setUserId(userVO.getId());
            userTenantRelationEntity.setTenantId(tenantId);
            userTenantRelationEntity.setTypeId(typeId!=null?typeId:2);
            userTenantRelationEntity.setEmployeeId(userVO.getId());
            userTenantRelationEntity.setOrgId(orgId);
            userTenantRelationEntity.setState(1);
            UserEntity userEntity = BeanMapper.map(userVO, UserEntity.class);

            //3、创建人员
            EmployeeVO employeeVO = new EmployeeVO();
            employeeVO.setId(userVO.getId());
            employeeVO.setUserId(userVO.getId());
            employeeVO.setSourceId(userInfo.getString("userid"));
            employeeVO.setName(userVO.getUserName());
            employeeVO.setCode(userInfo.getString("userid"));
            employeeVO.setEmployeeType(1);
            employeeVO.setState(1);
            employeeVO.setSex(1);
            if(StringUtils.isBlank(userEntity.getUserMobile())){
                employeeVO.setMobilePhone(userEntity.getSourceId());
            }else {
                employeeVO.setMobilePhone(userEntity.getUserMobile());
            }
            employeeVO.setOrgId(orgId);
            employeeVO.setTenantId(tenantId);

            userTenantRelationService.saveOrUpdate(userTenantRelationEntity, false);
            employeeService.save(employeeVO, userEntity);
            userService.saveOrUpdate(userEntity);

            userService.addUserApp(userVO.getId(), tenantId, orgId, typeId,"DDTHIRDAPP-INIT");
        }catch (Exception e){
            logger.info("新增用户报错----{}",e);
        }
    }
}
