package com.ejianc.foundation.usercenter.service;

import com.ejianc.foundation.usercenter.bean.UserThirdSystemEntity;
import com.ejianc.foundation.usercenter.vo.UserThirdSystemVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IUserThirdSystemService extends IBaseService<UserThirdSystemEntity> {

	/**
	 * 根据第三方系统账号，密码，系统ID查询对应用户
	 * 
	 * @param loginName
	 * @param password
	 * @param systemId
	 * @return
	 */
	UserThirdSystemEntity queryByUserNameAndPassword(String loginName, String password, Long systemId);

	/**
	 * 查询第三方绑定用户
	 * 
	 * @param thirdSystemId
	 * @param userId
	 * @return
	 */
	UserThirdSystemVO getExtUser(Long thirdSystemId, Long userId);

}
