/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.workbench.bean.LayoutRoleRelationEntity;
import com.ejianc.foundation.workbench.mapper.LayoutRoleRelationMapper;
import com.ejianc.foundation.workbench.service.ILayoutRoleRelationService;
import com.ejianc.foundation.workbench.vo.LayoutRoleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutRoleRelationServiceImpl
extends BaseServiceImpl<LayoutRoleRelationMapper, LayoutRoleRelationEntity>
implements ILayoutRoleRelationService {
    @Autowired
    LayoutRoleRelationMapper layoutRoleRelationMapper;

    @Override
    public Long count(Map<String, Object> paramMap, Long layoutId) {
        paramMap.put("layoutId", layoutId);
        paramMap.put("tenantId", InvocationInfoProxy.getTenantid());
        return this.layoutRoleRelationMapper.count(paramMap);
    }

    @Override
    public List<LayoutRoleVO> page(Map<String, Object> paramMap, int startLine, int pageSize, Long layoutId) {
        paramMap.put("layoutId", layoutId);
        paramMap.put("tenantId", InvocationInfoProxy.getTenantid());
        paramMap.put("startLine", startLine);
        paramMap.put("pageSize", pageSize);
        return this.layoutRoleRelationMapper.page(paramMap);
    }

    @Override
    public List<LayoutRoleRelationEntity> queryByProperties(Map<String, Object> param) {
        QueryWrapper query = new QueryWrapper();
        if (null != param.get("layoutId")) {
            query.eq((Object)"layout_id", (Object)Long.valueOf(param.get("layoutId").toString()));
        }
        if (null != param.get("roleIds")) {
            query.in((Object)"role_id", (Collection)((List)param.get("roleIds")).stream().map(r -> Long.valueOf(r)).collect(Collectors.toList()));
        }
        return ((LayoutRoleRelationMapper)this.baseMapper).selectList((Wrapper)query);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        String idStr = "";
        for (Long id : ids) {
            idStr = idStr + id + ",";
        }
        if (StringUtils.isNotBlank((CharSequence)idStr)) {
            idStr = idStr.substring(0, idStr.length() - 1);
            this.layoutRoleRelationMapper.deleteByIds(idStr);
        }
    }

    @Override
    public void delByRoleIdsAndOrgId(List<Long> roleIds, List<Long> layoutIds) {
        if (CollectionUtils.isNotEmpty(roleIds) || CollectionUtils.isNotEmpty(layoutIds)) {
            this.layoutRoleRelationMapper.delByRoleIdsAndOrgId(roleIds, layoutIds);
        }
    }
}

