/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jobService")
public class JobServiceImpl
extends BaseServiceImpl<JobMapper, JobEntity>
implements IJobService {
    @Autowired
    private JobMapper jobMapper;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;

    @Override
    public JobEntity getCurMainJob(Long employeeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"employee_id", (Object)employeeId);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"property", (Object)JobVO.JOB_TYPE_MAIN);
        queryWrapper.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
        return (JobEntity)((Object)((JobMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    public JobEntity getById(Long id) {
        return (JobEntity)((Object)super.getById((Serializable)id));
    }

    @Override
    public List<JobEntity> getEmployeesMainJob(List<Long> employeeIds, boolean isAll) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.in((Object)"employee_id", employeeIds);
        queryWrapper.eq((Object)"property", (Object)JobVO.JOB_TYPE_MAIN);
        if (!isAll) {
            queryWrapper.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
        }
        return ((JobMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<JobVO> queryAllJobByEmployeeId(Long emplmoyeeId, Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"employee_id", (Object)emplmoyeeId);
        queryWrapper.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        List jobEntities = ((JobMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (jobEntities != null && jobEntities.size() > 0) {
            return BeanMapper.mapList((Iterable)jobEntities, JobVO.class);
        }
        return null;
    }

    @Override
    public List<JobVO> queryPartJobsByEmployeeId(Long employeeId, Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"employee_id", (Object)employeeId);
        queryWrapper.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"property", (Object)JobVO.JOB_TYPE_PARTTIME);
        List jobEntities = ((JobMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (jobEntities != null && jobEntities.size() > 0) {
            return BeanMapper.mapList((Iterable)jobEntities, JobVO.class);
        }
        return null;
    }

    @Override
    public List<JobVO> queryJobsByOrgId(Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"org_id", (Object)orgId);
        queryWrapper.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
        List jobEntities = ((JobMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (jobEntities != null && jobEntities.size() > 0) {
            return BeanMapper.mapList((Iterable)jobEntities, JobVO.class);
        }
        return null;
    }

    @Override
    public void updateStateByEmpId(Long employeeId, Integer curState) {
        if (JobVO.STATE_INACTIVE.equals(curState)) {
            QueryWrapper jobQuery = new QueryWrapper();
            jobQuery.eq((Object)"employee_id", (Object)employeeId);
            jobQuery.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            jobQuery.eq((Object)"cur_state", (Object)JobVO.STATE_ACTIVE);
            jobQuery.eq((Object)"property", (Object)JobVO.JOB_TYPE_PARTTIME);
            List jobList = super.list((Wrapper)jobQuery);
            ArrayList jobIds = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)jobList)) {
                jobList.forEach(job -> {
                    jobIds.add(job.getId());
                    job.setCurState(JobVO.STATE_INACTIVE);
                    job.setJobEndTime(new Timestamp(System.currentTimeMillis()));
                });
                if (CollectionUtils.isNotEmpty(jobIds)) {
                    QueryParam roleUserQueryParam = new QueryParam();
                    roleUserQueryParam.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
                    roleUserQueryParam.getParams().put("jobId", new Parameter("in", jobIds));
                    List roleUserRelations = this.roleUserRelationService.queryList(roleUserQueryParam, false);
                    if (CollectionUtils.isNotEmpty((Collection)roleUserRelations)) {
                        this.roleUserRelationService.delete(roleUserRelations.stream().map(r -> r.getId()).collect(Collectors.toList()));
                    }
                }
                super.saveOrUpdateBatch(jobList, jobList.size(), false);
            }
        }
    }

    @Override
    public void deleteAllByEmployeeId(Long employeeId) {
        this.jobMapper.deleteAllByEmployeeId(employeeId);
    }

    @Override
    public void deleteAllPartJobByEmployeeId(Long employeeId) {
        this.jobMapper.deleteAllPartJobByEmployeeId(employeeId);
    }

    @Override
    public void updateDeptHeadNoByDeptId(Long deptId) {
        this.jobMapper.updateDeptHeadNoByDeptId(deptId);
    }
}

