/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.workbench.service.IWxeeThirdAppService;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WxeeThirdAppService
implements IWxeeThirdAppService,
Serializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private IEnterpriseService iEnterpriseService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IUserService iUserService;

    @Override
    @Transactional
    public void openApp(String tpmAuthCode) {
        this.log.info("\u7b2c\u4e00\u6b65\uff1a\u83b7\u53d6suite_ticket\uff01");
        String suite_ticket = this.thirdSystemService.getThirdAppSuiteTicket("wwdca16158f8d411bd", "wxee");
        if (StringUtils.isEmpty((CharSequence)suite_ticket)) {
            this.log.info("\u7f13\u5b58\u4e2dsuite_ticket\u4e3a\u7a7a\uff01");
            throw new BusinessException("\u7f13\u5b58\u4e2dsuite_ticket\u4e3a\u7a7a\uff01");
        }
        this.log.info("\u7b2c\u4e8c\u6b65\uff1a\u83b7\u53d6suite_access_token\uff01");
        JSONObject body = new JSONObject();
        body.put("suite_id", (Object)"wwdca16158f8d411bd");
        body.put("suite_secret", (Object)"px7JbJ6tKLbv_ukZxnpg_vvyjyHw5dpexwoz61-LGTY");
        body.put("suite_ticket", (Object)suite_ticket);
        String suite_access_token = this.thirdSystemService.getWXEESuiteAccessToken(body, "wwdca16158f8d411bd");
        this.log.info("\u7b2c\u4e09\u6b65\uff1a\u83b7\u53d6\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\uff01");
        body = new JSONObject();
        body.put("auth_code", (Object)tpmAuthCode);
        JSONObject promiseCode = this.thirdSystemService.getWXEEPermanentCode(suite_access_token, body);
        this.log.info("\u7b2c\u56db\u6b65\uff1a\u62fc\u88c5\u4f01\u4e1a\u4fe1\u606f\uff0c\u521d\u59cb\u5316\u64cd\u4f5c\uff01");
        JSONObject auth_corp_info = promiseCode.getJSONObject("auth_corp_info");
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        enterpriseVO.setComboCode("wxeeApp-init");
        enterpriseVO.setSourceFrom("wxee");
        enterpriseVO.setEnterpriseType("1");
        enterpriseVO.setBusinessType("1");
        enterpriseVO.setCommitTime(new Date());
        enterpriseVO.setAuditTime(new Date());
        enterpriseVO.setAuditName("\u7cfb\u7edf\u751f\u6210\uff01");
        enterpriseVO.setAuditOpinion("\u7cfb\u7edf\u751f\u6210\uff01\u901a\u8fc7\uff01");
        enterpriseVO.setExamineState("1");
        enterpriseVO.setCode("WXEE-APP-" + auth_corp_info.getString("corpid"));
        enterpriseVO.setPermanentCode(promiseCode.getString("permanent_code"));
        enterpriseVO.setName(auth_corp_info.getString("corp_name"));
        enterpriseVO.setFullName(auth_corp_info.getString("corp_full_name"));
        enterpriseVO.setCorpid(auth_corp_info.getString("corpid"));
        enterpriseVO.setDescription("\u4f01\u4e1a\u5fae\u4fe1\u7b2c\u4e09\u65b9\u5e94\u7528\u5f00\u5f00\u901a\u751f\u6210\uff01");
        enterpriseVO.setWays("6");
        if (promiseCode.getJSONObject("auth_info") == null) {
            this.log.info("\u6c38\u4e45\u6388\u6743\u7801\u672a\u8fd4\u56deauth_info\u4fe1\u606f\uff01");
            throw new BusinessException("\u6c38\u4e45\u6388\u6743\u7801\u672a\u8fd4\u56deauth_info\u4fe1\u606f\uff01");
        }
        JSONObject privilege = promiseCode.getJSONObject("auth_info").getJSONArray("agent").getJSONObject(0).getJSONObject("privilege");
        String[] userIds = new String[]{};
        if (privilege.getJSONArray("allow_user") != null) {
            userIds = (String[])privilege.getJSONArray("allow_user").toArray((Object[])new String[0]);
        }
        this.log.info("\u7b2c\u4e94\u6b65\uff1a\u83b7\u53d6\u5e94\u7528\u5bf9\u4f01\u4e1a\u7684access_token\uff01");
        body = new JSONObject();
        body.put("auth_corpid", (Object)auth_corp_info.getString("corpid"));
        body.put("permanent_code", (Object)promiseCode.getString("permanent_code"));
        String accessToken = promiseCode.getString("access_token");
        this.redisTemplate.opsForValue().set((Object)("EJB_corpid_AccessToken" + auth_corp_info.getString("corpid")), (Object)accessToken, 7000L, TimeUnit.SECONDS);
        this.log.info("\u7b2c\u516d\u6b65\uff1a\u83b7\u53d6\u6709\u6743\u9650\u7684\u7528\u6237\u4fe1\u606f\uff01");
        JSONArray userInfos = new JSONArray();
        HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>();
        for (String userId : userIds) {
            JSONObject info = this.thirdSystemService.getWXEEUserInfo(accessToken, userId);
            userInfos.add((Object)info);
            userMap.put(userId, info);
        }
        if (privilege.getJSONArray("allow_party") != null) {
            String[] deptIds;
            this.log.info("\u7b2c7\u6b65\uff1a\u83b7\u53d6\u6388\u6743\u90e8\u95e8\u4e0b\u7684\u6210\u5458\u7528\u6237\uff01");
            for (String deptId : deptIds = (String[])privilege.getJSONArray("allow_party").toArray((Object[])new String[0])) {
                JSONArray userList = this.thirdSystemService.getWXEEDeptUserList(accessToken, deptId);
                if (userList == null) continue;
                for (Object user : userList) {
                    JSONObject userInfo = (JSONObject)user;
                    if (userMap.get(userInfo.getString("userid")) != null) continue;
                    JSONObject info = this.thirdSystemService.getWXEEUserInfo(accessToken, userInfo.getString("userid"));
                    userInfos.add((Object)info);
                    userMap.put(userInfo.getString("userid"), info);
                }
            }
        }
        this.log.info("\u7b2c8\u6b65\uff1a\u62fc\u88c5\u7ba1\u7406\u5458\u7528\u6237\u4fe1\u606f\uff01");
        JSONObject superUser = userInfos.getJSONObject(0);
        JSONObject authUserInfo = promiseCode.getJSONObject("auth_user_info");
        if (authUserInfo != null) {
            enterpriseVO.setUserName(authUserInfo.getString("userid"));
            enterpriseVO.setUserCode(authUserInfo.getString("open_userid"));
            enterpriseVO.setUserSourceId(authUserInfo.getString("userid"));
        } else {
            enterpriseVO.setUserName(superUser.getString("name"));
            enterpriseVO.setTelephone(superUser.getString("mobile"));
            enterpriseVO.setUserCode(superUser.getString("open_userid"));
            enterpriseVO.setUserSourceId(superUser.getString("userid"));
        }
        this.log.info("\u7b2c\u516b\u6b65\uff1a\u521d\u59cb\u5316\u4f01\u4e1a\u3001\u79df\u6237\u3001\u8d85\u7ba1\u7b49\u7b49\uff01");
        this.iEnterpriseService.initData(enterpriseVO);
        this.log.info("\u7b2c\u516b\u6b65\uff1a\u521d\u59cb\u5316\u4f01\u4e1a\u3001\u79df\u6237\u3001\u8d85\u7ba1\u7b49\u7b49\uff01-------\u5b8c\u6210\uff01");
        this.log.info("\u7b2c\u5341\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316\uff01");
        for (Object user : userInfos) {
            JSONObject userInfo = (JSONObject)user;
            this.iUserService.initThirdAppUsers(userInfo.getString("userid"), userInfo.getString("name"), userInfo.getString("mobile"), userInfo.getString("open_userid"), enterpriseVO.getTenantId(), "WXEETHIRDAPP-INIT");
        }
        this.log.info("\u7b2c\u5341\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316\uff01-------\u5b8c\u6210\uff01");
    }

    @Override
    @Transactional
    public void changeAuth(String authCorpId, String suiteId) {
        this.log.info("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743 \u53d8\u66f4\u56de\u8c03 \u7b2c\u4e00\u6b65\uff1a\u83b7\u53d6 \u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\uff01--- authCorpId " + authCorpId + "  suiteId = " + suiteId);
        String promiseCode = this.thirdSystemService.getTenantPromiseCode(authCorpId);
        if (StringUtils.isEmpty((CharSequence)promiseCode)) {
            this.log.info("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743 \u53d8\u66f4\u56de\u8c03\uff01\u4f01\u4e1a\u6c38\u4e45\u6388\u6743\u7801\u4e3a\u7a7a\uff01");
            return;
        }
        this.log.info("\u7b2c2\u6b65\uff1a\u83b7\u53d6suite_ticket\uff01");
        String suite_ticket = this.thirdSystemService.getThirdAppSuiteTicket("wwdca16158f8d411bd", "wxee");
        if (StringUtils.isEmpty((CharSequence)suite_ticket)) {
            this.log.info("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743 \u53d8\u66f4\u56de\u8c03  \u7f13\u5b58\u4e2dsuite_ticket\u4e3a\u7a7a\uff01");
            return;
        }
        this.log.info("\u7b2c3\u6b65\uff1a\u83b7\u53d6suite_access_token\uff01");
        JSONObject body = new JSONObject();
        body.put("suite_id", (Object)"wwdca16158f8d411bd");
        body.put("suite_secret", (Object)"px7JbJ6tKLbv_ukZxnpg_vvyjyHw5dpexwoz61-LGTY");
        body.put("suite_ticket", (Object)suite_ticket);
        String suite_access_token = this.thirdSystemService.getWXEESuiteAccessToken(body, "wwdca16158f8d411bd");
        body = new JSONObject();
        body.put("auth_corpid", (Object)authCorpId);
        body.put("permanent_code", (Object)promiseCode);
        this.log.info("\u7b2c4\u6b65\uff1a\u83b7\u53d6\u6388\u6743\u4fe1\u606f\uff01");
        JSONObject authInfo = this.thirdSystemService.getWXEEAuthInfo(suite_access_token, body);
        JSONObject privilege = authInfo.getJSONObject("auth_info").getJSONArray("agent").getJSONObject(0).getJSONObject("privilege");
        String[] userIds = new String[]{};
        if (privilege.getJSONArray("allow_user") != null) {
            userIds = (String[])privilege.getJSONArray("allow_user").toArray((Object[])new String[0]);
        }
        String[] deptIds = new String[]{};
        if (privilege.getJSONArray("allow_party") != null) {
            StringBuilder ids = new StringBuilder();
            for (Object allowParty : privilege.getJSONArray("allow_party")) {
                ids.append(allowParty).append(",");
            }
            deptIds = ids.toString().split(",");
        }
        JSONArray userInfos = new JSONArray();
        HashMap<String, JSONObject> userMap = new HashMap<String, JSONObject>();
        body = new JSONObject();
        body.put("auth_corpid", (Object)authCorpId);
        body.put("permanent_code", (Object)promiseCode);
        this.log.info("\u7b2c5\u6b65\uff1a\u83b7\u53d6\u4f01\u4e1a accessToken\uff01");
        String accessToken = this.thirdSystemService.getWXEECorpToken(authCorpId, suite_access_token, body);
        this.log.info("\u7b2c6\u6b65\uff1a\u83b7\u53d6 \u4eba\u5458\u4fe1\u606f\uff01");
        for (String userId : userIds) {
            if (!StringUtils.isNotEmpty((CharSequence)userId)) continue;
            JSONObject info = this.thirdSystemService.getWXEEUserInfo(accessToken, userId);
            userInfos.add((Object)info);
            userMap.put(userId, info);
        }
        this.log.info("\u7b2c7\u6b65\uff1a\u6839\u636e\u6388\u6743\u90e8\u95e8\u83b7\u53d6\u5176\u4e0b\u6388\u6743\u4eba\u5458\u4fe1\u606f \uff01");
        for (String deptId : deptIds) {
            JSONArray userList;
            if (!StringUtils.isNotEmpty((CharSequence)deptId) || (userList = this.thirdSystemService.getWXEEDeptUserList(accessToken, deptId)) == null) continue;
            for (Object user : userList) {
                JSONObject userInfo = (JSONObject)user;
                if (userMap.get(userInfo.getString("userid")) != null) continue;
                JSONObject info = this.thirdSystemService.getWXEEUserInfo(accessToken, userInfo.getString("userid"));
                userInfos.add((Object)info);
                userMap.put(userInfo.getString("userid"), info);
            }
        }
        this.log.info("\u7b2c8\u6b65\uff1a\u6839\u636e\u4f01\u4e1aid\uff0c\u67e5\u8be2\u79df\u6237\u4fe1\u606f \uff01");
        TenantEntity tenantEntity = this.thirdSystemService.getTenantByThirdCorpid(authCorpId);
        this.log.info("\u7b2c9\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316 \uff01");
        for (Object user : userInfos) {
            JSONObject userInfo = (JSONObject)user;
            this.log.info(userInfo.toJSONString());
            this.iUserService.initThirdAppUsers(userInfo.getString("userid"), userInfo.getString("name"), userInfo.getString("mobile"), userInfo.getString("open_userid"), tenantEntity.getId(), "WXEETHIRDAPP-INIT");
        }
        this.log.info("\u7b2c9\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316\uff01-------\u5b8c\u6210\uff01");
    }

    @Override
    public void addUser(String authCorpId, String suiteId, String userId, String openUserID, String mobile) {
        this.log.info("\u901a\u8baf\u5f55\u53d8\u66f4\u4e8b\u4ef6\u901a\u77e5 \u65b0\u589e\u6210\u5458 \u7b2c\u4e00\u6b65\uff1a\u6839\u636e\u4f01\u4e1aid\uff0c\u67e5\u8be2\u79df\u6237\u4fe1\u606f \uff01--- authCorpId " + authCorpId);
        TenantEntity tenantEntity = this.thirdSystemService.getTenantByThirdCorpid(authCorpId);
        this.log.info("\u7b2c2\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316 \uff01");
        this.iUserService.initThirdAppUsers(userId, userId, mobile, openUserID, tenantEntity.getId(), "WXEETHIRDAPP-INIT");
        this.log.info("\u7b2c2\u6b65\uff1a\u5c06\u7528\u6237\u6301\u4e45\u5316\uff01-------\u5b8c\u6210\uff01");
    }

    @Override
    public void changeUser(String authCorpId, String suiteId, String oldUserId, String newUserId, String openUserID, String mobile, Integer state) {
        TenantEntity tenantEntity = this.thirdSystemService.getTenantByThirdCorpid(authCorpId);
        UserVO userVO = this.iUserService.queryUserBySourceId(oldUserId, tenantEntity.getId());
        if (userVO != null) {
            if (StringUtils.isNotEmpty((CharSequence)newUserId) && !newUserId.equals(oldUserId)) {
                userVO.setSourceId(newUserId);
                userVO.setUserName(newUserId);
            }
            userVO.setUserMobile(mobile);
            this.iUserService.updateThirdAppUsers(userVO, state);
        }
    }
}

