package com.ejianc.foundation.operatelog.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.operatelog.service.IOperateLogService;
import com.ejianc.foundation.operatelog.vo.OperateLogVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@Service
public class OperateLogServiceImpl implements IOperateLogService {
	
	private final static Integer QUERY_TIMEOUT = 60;
	private final static String ASC = "asc";
	private final static String INDEX_NAME = "ejclogspace";
	
	@Autowired(required=false)
	private RestHighLevelClient client;

	@Override
	public IPage<OperateLogVO> queryPageList(QueryParam queryParam) {
		IPage<OperateLogVO> page = new Page<>();
		
		SearchRequest searchRequest = new SearchRequest(INDEX_NAME);
		SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
		
		//查询参数
		Map<String, Parameter> paramMap = queryParam.getParams();
		BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
		for(Map.Entry<String, Parameter> entry: paramMap.entrySet()){
			Parameter param = entry.getValue();
			if(param.getValue() == null || StringUtils.isBlank(param.getValue() + "")) {
				continue;
			}
			if(QueryParam.EQ.equals(param.getType())) {
				boolQuery.must(QueryBuilders.termQuery(entry.getKey(), param.getValue().toString()));
			} else if(QueryParam.LIKE.equals(param.getType())) {
				boolQuery.must(QueryBuilders.matchQuery(entry.getKey(), param.getValue().toString()));
			} else if(QueryParam.IN.equals(param.getType())) {
				boolQuery.must(QueryBuilders.termQuery(entry.getKey(), param.getValue().toString().split(",")));
			} else if(QueryParam.BETWEEN.equals(param.getType())) {
				String[] dataArr = param.getValue().toString().split(",");
				boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).from(dataArr[0]).to(dataArr[1]).includeLower(true).includeUpper(true));
			} else if(QueryParam.GT.equals(param.getType())) {
				boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).gt(param.getValue().toString()));
			} else if(QueryParam.GE.equals(param.getType())){
				boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).gte(param.getValue().toString()));
			} else if(QueryParam.LT.equals(param.getType())) {
				boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).lt(param.getValue().toString()));
			} else if(QueryParam.LE.equals(param.getType())) {
				boolQuery.must(QueryBuilders.rangeQuery(entry.getKey()).lte(param.getValue().toString()));
			}
		}
		sourceBuilder.query(boolQuery);
		
		//排序
		Map<String, String> orderMap = queryParam.getOrderMap();
		if(orderMap != null && !orderMap.isEmpty()) {
			for(Map.Entry<String, String> entry : orderMap.entrySet()) {
				sourceBuilder.sort(new FieldSortBuilder(entry.getKey()+".keyword").order(ASC.equals(entry.getValue().toLowerCase())?SortOrder.ASC:SortOrder.DESC));
			}
		}
		
		sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex()-1)*queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        try {
        	page = queryPage(searchRequest);
        } catch (IOException e) {
        	try { //重试一次
				page = queryPage(searchRequest);
			} catch (IOException e1) {
				e1.printStackTrace();
        		throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
			}
        }
        return page;
	}
	
	//查询es
	private IPage<OperateLogVO> queryPage(SearchRequest searchRequest) throws IOException {
		IPage<OperateLogVO> page = new Page<>();
		List<OperateLogVO> list = new ArrayList<>();
        SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add(JSON.parseObject(sourceAsString, OperateLogVO.class));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
	}

}
