package com.ejianc.foundation.permission.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IAppService extends IBaseService<AppEntity> {


	CommonResponse<String> save(AppVO ApplicationVo, boolean b);

	CommonResponse<String> delete(List<Long> ids);

	AppVO queryDetail(Long id);

	/**
	 * 保存角色关系表
	 * 
	 * @param roleAppVO
	 * @return
	 */
	CommonResponse<String> saveRoleApp(RoleAppVO roleAppVO);

	List<AppVO> queryListByModuleId(Long moduleId, Long roleId, String searchText);

	List<AppVO> queryList(Map<String, Object> params);

	/**
	 * 根据主键ID查询对应的应用信息列表
	 *
	 * @param appIds
	 * @return
	 */
    List<AppEntity> queryAllByIds(List<Long> appIds);

    /**
     * 查询所有运营类应用
     * 
     * @return
     */
	List<Long> queryAllOperateList();

	/**
	 * 查询套餐内的所有运营类应用
	 * 
	 * @return
	 */
	List<Long> queryAllOmsOprateList();

	/**
	 * 查询有权限的所有运营类应用
	 * 
	 * @return
	 */
	List<Long> queryAuthOperateList();
	
	/**
	 * 查询有权限的所有运营类应用,套餐内的
	 * 
	 * @return
	 */
	List<Long> queryAuthOperateOmsList();

	/**
	 * 刷新应用缓存
	 */
	void refreshAppCache();

	//查询套餐内的应用
	IPage<AppEntity> wzxtRefAppList(int pageSize, int pageNumber,String condition);

	List<Long> queryAllHasAuthOmsOprateList();

	public List<AppVO> queryAppByUser();
}
