/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.foundation.permission.bean.ButtonEntity;
import com.ejianc.foundation.permission.bean.MangerUserAppRelationEntity;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.bean.RoleButtonRelationEntity;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IButtonService;
import com.ejianc.foundation.permission.service.IMangerUserAppRelationService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleButtonRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppServiceImpl
extends BaseServiceImpl<AppMapper, AppEntity>
implements IAppService {
    private static final String APP_BILL_CODE = "IDM_APP";
    @Value(value="${oms.tenantid}")
    private Long omsTenantid;
    @Autowired
    private IButtonService buttonService;
    @Autowired
    private IRoleAppRelationService roleAppRelationService;
    @Autowired
    private IRoleButtonRelationService roleButtonRelationService;
    @Autowired
    private IModuleApi moduleApi;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private AppCacheManage appCacheManage;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMangerUserAppRelationService mangerUserAppRelationService;

    @Override
    public CommonResponse<String> save(AppVO applicationVo, boolean syncEs) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AppEntity entity = new AppEntity();
        boolean isAdd = true;
        if (applicationVo.getId() != null) {
            ArrayList<Long> attachIds;
            String id;
            AppEntity oldEntity = (AppEntity)((Object)super.getById((Serializable)applicationVo.getId()));
            if (StringUtils.isNotBlank((String)oldEntity.getAppIconSrc())) {
                if (StringUtils.isNotBlank((String)applicationVo.getAppIconSrc())) {
                    if (!oldEntity.getAppIconSrc().equals(applicationVo.getAppIconSrc())) {
                        if (StringUtils.isNotBlank((String)oldEntity.getAppIconSrc()) && oldEntity.getAppIconSrc().contains("=") && StringUtils.isNotBlank((String)(id = oldEntity.getAppIconSrc().split("=")[1]))) {
                            this.attachmentApi.delete(id);
                        }
                        if (StringUtils.isNotBlank((String)applicationVo.getAppIconSrc()) && applicationVo.getAppIconSrc().contains("=") && StringUtils.isNotBlank((String)(id = applicationVo.getAppIconSrc().split("=")[1]))) {
                            attachIds = new ArrayList();
                            attachIds.add(Long.parseLong(id));
                            this.attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
                        }
                    }
                } else if (StringUtils.isNotBlank((String)oldEntity.getAppIconSrc()) && oldEntity.getAppIconSrc().contains("=") && StringUtils.isNotBlank((String)(id = oldEntity.getAppIconSrc().split("=")[1]))) {
                    this.attachmentApi.delete(id);
                }
            } else if (StringUtils.isNotBlank((String)applicationVo.getAppIconSrc()) && StringUtils.isNotBlank((String)applicationVo.getAppIconSrc()) && applicationVo.getAppIconSrc().contains("=") && StringUtils.isNotBlank((String)(id = applicationVo.getAppIconSrc().split("=")[1]))) {
                attachIds = new ArrayList<Long>();
                attachIds.add(Long.parseLong(id));
                this.attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
            }
            oldEntity.setCode(applicationVo.getCode());
            oldEntity.setName(applicationVo.getName());
            oldEntity.setSequence(applicationVo.getSequence());
            oldEntity.setBtnPower(applicationVo.getBtnPower());
            oldEntity.setModuleId(applicationVo.getModuleId());
            oldEntity.setNotes(applicationVo.getNotes());
            oldEntity.setSource(applicationVo.getSource());
            oldEntity.setAppAddPath(applicationVo.getAppAddPath());
            if (applicationVo.getSource() == 2) {
                oldEntity.setClassify(applicationVo.getClassify());
                oldEntity.setPcUrl("/portal/outer/sso/redirect?appcode=" + oldEntity.getCode());
                oldEntity.setMobileUrl("");
            } else {
                oldEntity.setClassify(applicationVo.getClassify());
                oldEntity.setPcUrl(applicationVo.getPcUrl());
                oldEntity.setMobileUrl(applicationVo.getMobileUrl());
            }
            oldEntity.setAppIconSrc(applicationVo.getAppIconSrc());
            oldEntity.setOpenMode(applicationVo.getOpenMode());
            oldEntity.setType(applicationVo.getType());
            entity = (AppEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), AppEntity.class));
            isAdd = false;
        } else {
            CommonResponse appResponse = this.billCodeApi.getCodeBatchByRuleCode(APP_BILL_CODE, tenantId);
            if (!appResponse.isSuccess()) {
                throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            applicationVo.setCode((String)appResponse.getData());
            if (applicationVo.getSource() == 2) {
                applicationVo.setPcUrl("/portal/outer/sso/redirect?appcode=" + applicationVo.getCode());
                applicationVo.setMobileUrl("");
            }
            applicationVo.setDr(Integer.valueOf(0));
            entity = (AppEntity)((Object)BeanMapper.map((Object)applicationVo, AppEntity.class));
            isAdd = true;
        }
        this.saveOrUpdate((Object)entity, syncEs);
        List btnPowers = applicationVo.getChildren();
        ArrayList<ButtonEntity> btnPowerEntitys = new ArrayList<ButtonEntity>();
        ArrayList<Long> delbtnPowersIds = new ArrayList<Long>();
        ArrayList<ButtonVO> delBtn = new ArrayList<ButtonVO>();
        for (ButtonVO vo : btnPowers) {
            ButtonEntity en;
            if (StringUtils.isNotBlank((String)vo.getRowState()) && vo.getRowState().equals("add")) {
                en = (ButtonEntity)((Object)BeanMapper.map((Object)vo, ButtonEntity.class));
                en.setAppId(entity.getId());
                en.setDr(0);
                btnPowerEntitys.add(en);
            }
            if (StringUtils.isNotBlank((String)vo.getRowState()) && vo.getRowState().equals("edit")) {
                en = (ButtonEntity)((Object)BeanMapper.map((Object)vo, ButtonEntity.class));
                btnPowerEntitys.add(en);
            }
            if (!StringUtils.isNotBlank((String)vo.getRowState()) || !vo.getRowState().equals("del")) continue;
            delbtnPowersIds.add(vo.getId());
            delBtn.add(vo);
        }
        if (btnPowerEntitys.size() > 0) {
            this.buttonService.saveOrUpdateBatch(btnPowerEntitys, btnPowerEntitys.size(), syncEs);
        }
        if (delbtnPowersIds.size() > 0) {
            this.buttonService.removeByIds(delbtnPowersIds, syncEs);
        }
        this.appCacheManage.putAppBeanToCache(tenantId, (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class));
        if (ListUtil.isNotEmpty(btnPowerEntitys)) {
            this.appCacheManage.putBtnToCache(BeanMapper.mapList(btnPowerEntitys, ButtonVO.class));
        }
        this.appCacheManage.rmBtnFromCache(delBtn);
        if (ListUtil.isNotEmpty(delbtnPowersIds)) {
            QueryParam param = new QueryParam();
            param.getParams().put("buttonId", new Parameter("in", delbtnPowersIds));
            List roleButtonRelationEntities = this.roleButtonRelationService.queryList(param);
            if (ListUtil.isNotEmpty((List)roleButtonRelationEntities)) {
                this.appCacheManage.rmBtnRoleFromCache(delBtn, roleButtonRelationEntities.stream().map(RoleButtonRelationEntity::getRoleId).collect(Collectors.toList()));
            }
        }
        if (isAdd) {
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public CommonResponse<String> delete(List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"app_id", ids);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List list = this.roleAppRelationService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            ArrayList appIds = new ArrayList();
            list.forEach(e -> appIds.add(e.getAppId()));
            List appList = (List)this.listByIds(appIds);
            if (appList.size() > 0) {
                String message = "";
                for (AppEntity app : appList) {
                    if (message.length() > 0) {
                        message = message + "\u3001" + app.getName();
                        continue;
                    }
                    message = message + app.getName();
                }
                throw new BusinessException(message + "\u5df2\u88ab\u5206\u914d\u89d2\u8272\uff0c\u8bf7\u5148\u5220\u9664\u89d2\u8272\u4e0e\u5e94\u7528\u7684\u5173\u7cfb");
            }
        }
        super.removeByIds(ids);
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long appId : ids) {
            this.appCacheManage.removeAppCache(tenantId, appId);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public AppVO queryDetail(Long id) {
        AppEntity entity = (AppEntity)((Object)super.getById((Serializable)id));
        if (entity != null) {
            AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"app_id", (Object)id);
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"sequence");
            List<ButtonEntity> rtnPowers = this.buttonService.querylist((QueryWrapper<ButtonEntity>)queryWrapper);
            List vos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
            vo.setChildren(vos);
            CommonResponse moduleVO = this.moduleApi.getModuleById(entity.getModuleId());
            if (moduleVO.isSuccess() && moduleVO.getData() != null) {
                vo.setModuleName(((ModuleVO)moduleVO.getData()).getModuleName());
            }
            return vo;
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u4e3b\u952e\u5bf9\u5e94\u7684\u8be6\u60c5");
    }

    @Override
    public List<AppVO> queryListByModuleId(Long moduleId, Long roleId, String searchText) {
        List list;
        ArrayList<Long> moduleIds = new ArrayList<Long>();
        CommonResponse moduleResponse = this.moduleApi.queryModuleListByPid(moduleId);
        if (moduleResponse.isSuccess()) {
            List modules = (List)moduleResponse.getData();
            for (int i = 0; i < modules.size(); ++i) {
                moduleIds.add(((ModuleVO)modules.get(i)).getId());
            }
        }
        CommonResponse response = this.paramConfigApi.getByCode("P-20X5K80186");
        if (!Objects.equals(InvocationInfoProxy.getUserType(), "1") && response.isSuccess() && Objects.equals("1", ((ParamRegisterSetVO)response.getData()).getValueData())) {
            QueryParam param = new QueryParam();
            param.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List appRelationEntities = this.mangerUserAppRelationService.queryList(param);
            if (ListUtil.isEmpty((List)appRelationEntities)) {
                return new ArrayList<AppVO>();
            }
            param = new QueryParam();
            param.getParams().put("id", new Parameter("in", appRelationEntities.stream().map(MangerUserAppRelationEntity::getAppId).collect(Collectors.toList())));
            param.getParams().put("module_id", new Parameter("in", moduleIds));
            list = this.queryList(param);
        } else if (InvocationInfoProxy.getTenantid().equals(this.omsTenantid)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"module_id", moduleIds);
            queryWrapper.in((Object)"classify", new Object[]{2, 3});
            if (StringUtils.isNotBlank((String)searchText)) {
                queryWrapper.like((Object)"name", (Object)searchText);
            }
            queryWrapper.orderByAsc((Object)"sequence");
            queryWrapper.orderByDesc((Object)"create_time");
            list = this.list((Wrapper)queryWrapper);
        } else {
            list = this.appMapper.queryAuthAppByTenantId(InvocationInfoProxy.getTenantid(), moduleIds, searchText);
        }
        List<AppVO> selfRoleApp = this.roleAppRelationService.queryAuthListByRoleId(roleId);
        HashMap<Long, Long> selfRoleMap = new HashMap<Long, Long>();
        if (selfRoleApp != null && selfRoleApp.size() > 0) {
            for (AppVO appVo : selfRoleApp) {
                selfRoleMap.put(appVo.getId(), appVo.getId());
            }
        }
        ArrayList<AppVO> vos = new ArrayList<AppVO>();
        for (AppEntity entity : list) {
            List btnvos;
            List<ButtonEntity> rtnPowers;
            QueryWrapper wrapper;
            AppVO vo = (AppVO)BeanMapper.map((Object)((Object)entity), AppVO.class);
            if (!selfRoleMap.containsKey(vo.getId())) {
                if (vo.getBtnPower() == 1) {
                    wrapper = new QueryWrapper();
                    wrapper.eq((Object)"app_id", (Object)vo.getId());
                    wrapper.eq((Object)"dr", (Object)0);
                    wrapper.orderByAsc((Object)"sequence");
                    rtnPowers = this.buttonService.querylist((QueryWrapper<ButtonEntity>)wrapper);
                    btnvos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
                    if (btnvos != null && btnvos.size() > 0) {
                        for (ButtonVO buttonVo : btnvos) {
                            vo.getChildren().add(buttonVo);
                        }
                    }
                    vos.add(vo);
                    continue;
                }
                vos.add(vo);
                continue;
            }
            if (vo.getBtnPower() != 1) continue;
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"app_id", (Object)vo.getId());
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.orderByAsc((Object)"sequence");
            rtnPowers = this.buttonService.querylist((QueryWrapper<ButtonEntity>)wrapper);
            btnvos = BeanMapper.mapList(rtnPowers, ButtonVO.class);
            if (btnvos != null && btnvos.size() > 0) {
                for (ButtonVO buttonVo : btnvos) {
                    if (selfRoleMap.containsKey(buttonVo.getId())) continue;
                    vo.getChildren().add(buttonVo);
                }
            }
            if (vo.getChildren().size() <= 0) continue;
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<AppEntity> queryAllByIds(List<Long> appIds) {
        return ((AppMapper)this.baseMapper).selectBatchIds(appIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<String> saveRoleApp(RoleAppVO roleAppVO) {
        if (roleAppVO.getRoleId() == null) return CommonResponse.error((String)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        List appVo = roleAppVO.getAppVO();
        if (appVo == null) return CommonResponse.error((String)"\u4fdd\u5b58\u5e94\u7528\u6570\u636e\u4e3a\u7a7a");
        Long roleId = roleAppVO.getRoleId();
        ArrayList<RoleAppRelationEntity> appList = new ArrayList<RoleAppRelationEntity>();
        ArrayList<RoleButtonRelationEntity> btnList = new ArrayList<RoleButtonRelationEntity>();
        for (AppVO vo : appVo) {
            RoleAppRelationEntity appEntity = new RoleAppRelationEntity();
            appEntity.setAppId(vo.getId());
            appEntity.setRoleId(roleId);
            appEntity.setTenantId(vo.getTenantId());
            appList.add(appEntity);
            List btn = vo.getChildren() != null ? vo.getChildren() : new ArrayList();
            for (ButtonVO bt : btn) {
                RoleButtonRelationEntity bentity = new RoleButtonRelationEntity();
                bentity.setAppId(vo.getId());
                bentity.setRoleId(roleId);
                bentity.setButtonId(bt.getId());
                btnList.add(bentity);
            }
        }
        if (appList.size() > 0) {
            this.roleAppRelationService.saveOrUpdateBatch(appList, appList.size(), false);
        }
        if (btnList.size() > 0) {
            this.roleButtonRelationService.saveOrUpdateBatch(btnList, btnList.size(), false);
        }
        this.permissionCacheManage.putRoleAppsCache(roleId, appVo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<AppVO> queryList(Map<String, Object> params) {
        List<Object> entitys = new ArrayList();
        if (!InvocationInfoProxy.getTenantid().equals(this.omsTenantid)) {
            entitys = this.appMapper.queryList(InvocationInfoProxy.getTenantid());
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            for (String key : params.keySet()) {
                if (key.equals("classify")) {
                    if (params.get(key).equals("oms")) {
                        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)key, (Object)1)).or()).eq((Object)key, (Object)3);
                        continue;
                    }
                    queryWrapper.eq((Object)key, params.get(key));
                    continue;
                }
                queryWrapper.eq((Object)key, params.get(key));
            }
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.orderByAsc((Object)"sequence");
            queryWrapper.orderByDesc((Object)"create_time");
            entitys = ((AppMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        }
        return BeanMapper.mapList(entitys, AppVO.class);
    }

    @Override
    public List<Long> queryAllOperateList() {
        List<Long> appIds = this.appMapper.queryAllOperateList();
        return appIds;
    }

    @Override
    public List<Long> queryAllOmsOprateList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> appIds = this.appMapper.queryAllOmsOprateList(tenantId);
        return appIds;
    }

    @Override
    public List<Long> queryAllHasAuthOmsOprateList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> appIds = this.appMapper.queryAllHasAuthOmsOprateList(tenantId);
        return appIds;
    }

    @Override
    public List<AppVO> queryAppByUser() {
        return null;
    }

    @Override
    public List<Long> queryAuthOperateList() {
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> appIds = this.appMapper.queryAuthOperateList(userId, tenantId);
        return appIds;
    }

    @Override
    public List<Long> queryAuthOperateOmsList() {
        Long userId = InvocationInfoProxy.getUserid();
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Long> appIds = this.appMapper.queryAuthOperateOmsList(userId, tenantId);
        return appIds;
    }

    @Override
    public void refreshAppCache() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.orderByAsc((Object)"sequence");
        List entities = this.appMapper.selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            List appVoList = BeanMapper.mapList((Iterable)entities, AppVO.class);
            this.appCacheManage.putAppListToCache(tenantId, appVoList);
            QueryWrapper wrapper = new QueryWrapper();
            entities.forEach(app -> {
                wrapper.eq((Object)"dr", (Object)0);
                wrapper.eq((Object)"app_id", (Object)app.getId());
                List<ButtonEntity> rtnPowers = this.buttonService.querylist((QueryWrapper<ButtonEntity>)wrapper);
                this.appCacheManage.putBtnToCache(BeanMapper.mapList(rtnPowers, ButtonVO.class));
            });
        }
    }

    @Override
    public IPage<AppEntity> wzxtRefAppList(int pageSize, int pageNumber, String condition) {
        JSONObject object;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageIndex", pageNumber);
        params.put("pageSize", pageSize);
        if (params.get("pageIndex") != null) {
            Integer pn = pageNumber - 1 < 0 ? 1 : pageNumber;
            long startLine = (pn - 1) * pageSize;
            params.put("startLine", startLine);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(object = JSONObject.parseObject((String)condition)).getString("classify"))) {
            params.put("classify", object.getString("classify"));
        }
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count = this.appMapper.countComboApp(params);
        Page page = new Page();
        if (count > 0L) {
            List<AppEntity> appEntity = this.appMapper.queryComboApp(params);
            page.setRecords(appEntity);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }
}

