package com.ejianc.foundation.permission.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 应用bean
 * 
 * 增加父ID： 如果某个租户对应的应用需要个性化， 则只要增加子节点就行。
 * 
 * @author guominga
 */
@TableName("ejc_idm_app")
public class AppEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;
	@TableField(value = "module_id")
	private Long moduleId;// 应用分组Id

	@TableField(value = "code")
	private String code;// 应用编码

	@TableField(value = "name")
	private String name;// 应用名称

	@TableField(value = "source")
	private Integer source;// 应用来源 1内部  2外部

	@TableField(value = "classify")
	private Integer classify;// 应用分类 1运营  2业务  3运营+业务 5协同应用

	@TableField(value = "type")
	private String type;// 应用类型 1PC 2移动

	@TableField(value = "pc_url")
	private String pcUrl;// pc地址

	@TableField(value = "mobile_url")
	private String mobileUrl;// 移动地址

	@TableField(value = "btn_power")
	private Integer btnPower;// 按钮权限 1启用 2停用

	@TableField(value = "notes")
	private String notes;// 备注
	
	@TableField(value = "sequence")
	private String sequence;// 排序
	
	@TableField(value = "app_icon_src")
	private String appIconSrc;// 应用图标预览地址
	
	@TableField(value = "open_mode")
	private String openMode;// 打开方式，1、系统内页签，2、浏览器页签

	@TableField(value = "app_add_path")
	private String appAddPath;// 应用新增页面路径，仅用于pc菜单使用

	public String getAppAddPath() {
		return appAddPath;
	}

	public void setAppAddPath(String appAddPath) {
		this.appAddPath = appAddPath;
	}

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getSource() {
		return source;
	}

	public void setSource(Integer source) {
		this.source = source;
	}

	public Integer getClassify() {
		return classify;
	}

	public void setClassify(Integer classify) {
		this.classify = classify;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getPcUrl() {
		return pcUrl;
	}

	public void setPcUrl(String pcUrl) {
		this.pcUrl = pcUrl;
	}

	public String getMobileUrl() {
		return mobileUrl;
	}

	public void setMobileUrl(String mobileUrl) {
		this.mobileUrl = mobileUrl;
	}

	public Integer getBtnPower() {
		return btnPower;
	}

	public void setBtnPower(Integer btnPower) {
		this.btnPower = btnPower;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public String getSequence() {
		return sequence;
	}

	public void setSequence(String sequence) {
		this.sequence = sequence;
	}

	public String getAppIconSrc() {
		return appIconSrc;
	}

	public void setAppIconSrc(String appIconSrc) {
		this.appIconSrc = appIconSrc;
	}

	public String getOpenMode() {
		return openMode;
	}

	public void setOpenMode(String openMode) {
		this.openMode = openMode;
	}

}
