package com.ejianc.foundation.permission.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.permission.bean.AppEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface AppMapper extends BaseCrudMapper<AppEntity> {

	List<Long> queryAllOperateList();

	List<Long> queryAllOmsOprateList(@Param("tenantId") Long tenantId);

	//查询套餐内启用的/没到期的应用（菜单查询时使用）
	List<Long> queryAllHasAuthOmsOprateList(@Param("tenantId") Long tenantId);

	List<Long> queryAuthOperateList(@Param("userId") Long userId, @Param("tenantId") Long tenantId);
	
	List<Long> queryAuthOperateOmsList(@Param("userId") Long userId, @Param("tenantId") Long tenantId);
	
	//查询租户分配套餐下的应用详情(不含运营，只查业务)
	List<AppEntity> queryAuthAppByTenantId(@Param("tenantId") Long tenantId,@Param("moduleIds") List<Long> moduleIds,@Param("searchText") String searchText);

	List<AppEntity> queryList(@Param("tenantId") Long tenantid);
	
	//查询当前租户的套餐内的应用
    Long countComboApp(Map<String, Object> queryParam);
    
    //查询当前租户的套餐内的应用
    List<AppEntity> queryComboApp(Map<String, Object> queryParam);
}
