/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.sign.bean.SignEntity;
import com.ejianc.foundation.sign.mapper.SignMapper;
import com.ejianc.foundation.sign.service.ISignService;
import com.ejianc.foundation.sign.vo.SignVO;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="signService")
public class SignServiceImpl
extends BaseServiceImpl<SignMapper, SignEntity>
implements ISignService {
    @Autowired
    private SignMapper signMapper;
    @Autowired
    private ISignService signService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IEmployeeService employeeService;

    @Override
    public void updateFromEmpployee(Long userId, Long fileId, String fileUrl) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"default_flag", (Object)"1");
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.list((Wrapper)queryWrapper);
        SignEntity defaultEntity = null;
        if (list != null && list.size() > 0) {
            defaultEntity = (SignEntity)((Object)list.get(0));
        }
        if (fileId != null) {
            if (defaultEntity != null && !fileId.toString().equals(defaultEntity.getFileId())) {
                this.attachmentApi.delete(defaultEntity.getFileId());
                this.remove((Wrapper)queryWrapper, false);
            }
            if (defaultEntity != null && !fileId.toString().equals(defaultEntity.getFileId()) || defaultEntity == null) {
                SignEntity signEntity = new SignEntity();
                signEntity.setDefaultFlag(true);
                signEntity.setFileId(fileId.toString());
                signEntity.setFileUrl(fileUrl);
                signEntity.setUserId(userId);
                this.signService.saveOrUpdate((Object)signEntity, false);
            }
        } else {
            if (list != null && list.size() > 0) {
                this.attachmentApi.delete(((SignEntity)((Object)list.get(0))).getFileId());
            }
            this.remove((Wrapper)queryWrapper, false);
        }
    }

    @Override
    public SignEntity getUserDefaultSign(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"default_flag", (Object)"1");
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            return (SignEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public void updateState(Long id) {
        SignEntity signEntity = (SignEntity)((Object)this.selectById(id));
        this.updateUserId(signEntity.getUserId());
        signEntity.setDefaultFlag(true);
        EmployeeVO employee = this.employeeService.queryEmployeeByUserId(signEntity.getUserId());
        EmployeeEntity employeeEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employee, EmployeeEntity.class));
        employeeEntity.setUserSignaturePath(signEntity.getFileUrl());
        this.employeeService.saveOrUpdate((Object)employeeEntity, false);
        this.signService.saveOrUpdate((Object)signEntity, false);
    }

    @Override
    public SignVO saveOrUpdates(SignEntity entity, boolean b) {
        if (this.selectDefaultFlag(entity.getUserId()).booleanValue()) {
            entity.setDefaultFlag(false);
        }
        super.saveOrUpdate((Object)entity, false);
        SignVO vo = (SignVO)BeanMapper.map((Object)((Object)entity), SignVO.class);
        return vo;
    }

    public void updateUserId(Long userId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"default_flag", (Object)false);
        updateWrapper.eq((Object)"user_id", (Object)userId);
        this.update((Wrapper)updateWrapper);
    }

    public Boolean selectDefaultFlag(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.signMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return true;
        }
        return false;
    }

    @Override
    public List<SignVO> queryByUserIdList(List<Long> userList) {
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter("in", userList));
        param.getParams().put("defaultFlag", new Parameter("eq", (Object)true));
        List list = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SignVO.class);
        return voList;
    }
}

