package com.ejianc.foundation.orgcenter.bean;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 员工bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_employee")
public class EmployeeEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 公司ID
	 */
	@TableField(value = "org_id")
	private Long orgId;

	/**
	 * 部门ID
	 */
	@TableField(value = "dept_id")
	private Long deptId;

	/**
	 * 岗位ID
	 */
	@TableField(value = "post_id")
	private Long postId;

	/**
	 * 用户ID
	 */
	@TableField(value = "user_id")
	private Long userId;

	/**
	 * 员工编号
	 */
	@TableField(value = "code")
	private String code;

	/**
	 * 员工名称
	 */
	@TableField(value = "name")
	private String name;

	/**
	 * 头像
	 */
	@TableField(value = "photo_path")
	private String photoPath;

	/**
	 * 身份证号
	 */
	@TableField(value = "idcard")
	private String idcard;

	/**
	 * 出生日期
	 */
	@TableField(value = "birthday")
	private Date birthday;

	/**
	 * 性别 1：男 2：女
	 */
	@TableField(value = "sex")
	private Integer sex;

	/**
	 * 手机号码
	 */
	@TableField(value = "mobile_phone")
	private String mobilePhone;

	/**
	 * 其他电话
	 */
	@TableField(value = "other_phone")
	private String otherPhone;

	/**
	 * 员工状态（1:在职，2：离职， 3：退休， 4：退休返聘,5：派驻人员，6：外借人员，7：外聘员工，8：待岗人员，9：过路人员，10：三庄人员，
	 * 	       11：挂证人员，12：应聘人员，13：其它, 14:劳务派遣）
	 */
	@TableField(value = "employee_type")
	private Integer employeeType;

	/**
	 * 备注
	 */
	@TableField(value = "note")
	private String note;

	/**
	 * 状态标识 (1:启用，0：停用)
	 */
	@TableField(value = "state")
	private Integer state;

	/**
	 * 排序
	 */
	@TableField(value = "sequence")
	private Integer sequence;

	/**
	 * 入职时间
	 */
	@TableField(value = "work_time")
	private Date workTime;

	@TableField(value = "source_id")
	private String sourceId; // 来源组织id

	@TableField(value = "system_id")
	private String systemId; // 系统id

	/**
	 * 用户签名图片路径
	 */
	@TableField(value = "user_signature_path")
	private String userSignaturePath;

	/**
	 * 郑州一建----start----
	 */
	@TableField(value = "post_level_code")
	private String postLevelCode; // 职务级别

	@TableField(value = "job_level_code")
	private String jobLevelCode; // 岗位级别
	/**
	 * 郑州一建----end----
	 */

	public String getUserSignaturePath() {
		return userSignaturePath;
	}

	public void setUserSignaturePath(String userSignaturePath) {
		this.userSignaturePath = userSignaturePath;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getPostId() {
		return postId;
	}

	public void setPostId(Long postId) {
		this.postId = postId;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhotoPath() {
		return photoPath;
	}

	public void setPhotoPath(String photoPath) {
		this.photoPath = photoPath;
	}

	public String getIdcard() {
		return idcard;
	}

	public void setIdcard(String idcard) {
		this.idcard = idcard;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Integer getSex() {
		return sex;
	}

	public void setSex(Integer sex) {
		this.sex = sex;
	}

	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	public String getOtherPhone() {
		return otherPhone;
	}

	public void setOtherPhone(String otherPhone) {
		this.otherPhone = otherPhone;
	}

	public Integer getEmployeeType() {
		return employeeType;
	}

	public void setEmployeeType(Integer employeeType) {
		this.employeeType = employeeType;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Date getWorkTime() {
		return workTime;
	}

	public void setWorkTime(Date workTime) {
		this.workTime = workTime;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getPostLevelCode() {
		return postLevelCode;
	}

	public void setPostLevelCode(String postLevelCode) {
		this.postLevelCode = postLevelCode;
	}

	public String getJobLevelCode() {
		return jobLevelCode;
	}

	public void setJobLevelCode(String jobLevelCode) {
		this.jobLevelCode = jobLevelCode;
	}
}
