package com.ejianc.support.idworker.util;

import org.apache.commons.lang.StringUtils;

public final class Assert {

    public static void isTrue(boolean expression, String message, Object... params) {
        if (!expression) {
            throw new RuntimeException(message+",data: "+params);
        }
    }

    public static void isFalse(boolean expression, String message, Object... params) {
        isTrue(!expression, message, params);
    }

    public static void isNull(Object object, String message, Object... params) {
        isTrue(object == null, message, params);
    }

    public static void notNull(Object object, String message, Object... params) {
        isTrue(object != null, message, params);
    }

    public static void notEmpty(String value, String message, Object... params) {
        isTrue(StringUtils.isNotEmpty(value), message, params);
    }
   
}
