package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 产值进度
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public class ProductionVo extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 产值时间
     */
    @TableField("production_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 本期完成产值（含税）
     */
    @TableField("finish_tax_mny")
    private BigDecimal finishTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本期完成产值（不含税）
     */
    @TableField("finish_mny")
    private BigDecimal finishMny;

    /**
     * 累计完成产值(含税)
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;

    /**
     * 累计完成产值（不含税）
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;
    /**
     * 合同应付款
     */
    private BigDecimal shouldPayMny;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;
    //本期形象进度
    private BigDecimal imageProgress;
    //累计形象进度
    private BigDecimal sumImageProgress;
    private String billStateName;
    /**
     * 是否被甲方报量引用过,0-否，1-是
     */
    @TableField("quote_flag")
    private Integer quoteFlag;
    private Integer contractVersion;

    private BigDecimal sumProductionTaxMnyHaveThis; // 累计完成产值(含本期)
    private BigDecimal sumProductionMnyHaveThis; // 累计完成产值(含本期)
    private BigDecimal sumImageProgressHaveThis; // 累计形象进度(含本期)

    private List<ProductionDetailVo> checkList = new ArrayList<>();
    private List<ProductionClaimVo> claimList = new ArrayList<>();

    private List<ProductionOtherVO> otherList = new ArrayList<>();

    public List<ProductionOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<ProductionOtherVO> otherList) {
        this.otherList = otherList;
    }

    public BigDecimal getSumProductionTaxMnyHaveThis() {
        return sumProductionTaxMnyHaveThis;
    }

    public void setSumProductionTaxMnyHaveThis(BigDecimal sumProductionTaxMnyHaveThis) {
        this.sumProductionTaxMnyHaveThis = sumProductionTaxMnyHaveThis;
    }

    public BigDecimal getSumProductionMnyHaveThis() {
        return sumProductionMnyHaveThis;
    }

    public void setSumProductionMnyHaveThis(BigDecimal sumProductionMnyHaveThis) {
        this.sumProductionMnyHaveThis = sumProductionMnyHaveThis;
    }

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }

    public BigDecimal getSumImageProgressHaveThis() {
        return sumImageProgressHaveThis;
    }

    public void setSumImageProgressHaveThis(BigDecimal sumImageProgressHaveThis) {
        this.sumImageProgressHaveThis = sumImageProgressHaveThis;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public Integer getQuoteFlag() {
        return quoteFlag;
    }

    public void setQuoteFlag(Integer quoteFlag) {
        this.quoteFlag = quoteFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getImageProgress() {
        return imageProgress;
    }

    public void setImageProgress(BigDecimal imageProgress) {
        this.imageProgress = imageProgress;
    }

    public BigDecimal getSumImageProgress() {
        return sumImageProgress;
    }

    public void setSumImageProgress(BigDecimal sumImageProgress) {
        this.sumImageProgress = sumImageProgress;
    }


    public List<ProductionDetailVo> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ProductionDetailVo> checkList) {
        this.checkList = checkList;
    }

    public List<ProductionClaimVo> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<ProductionClaimVo> claimList) {
        this.claimList = claimList;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

}
