/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String CURRENT_YEAR = DateUtil.getCurrentYear();

    public static Integer getSubDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time1 - time2) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Integer days = Integer.parseInt(String.valueOf(betweenDays));
        return days < 0 ? days - 1 : days + 1;
    }

    public static int compareDate(Date dt1, Date dt2) {
        try {
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static Date maxDate(Date date1, Date date2, Boolean flag) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (flag.booleanValue()) {
            if (DateUtil.compareDate(date1, date2) < 0) {
                return date2;
            }
            return date1;
        }
        if (DateUtil.compareDate(date1, date2) < 0) {
            return date1;
        }
        return date2;
    }

    public static String getMonthStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return String.format("%02d", month);
    }

    public static Date nextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        return cal.getTime();
    }

    public static String getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return String.valueOf(cal.get(1));
    }

    public static String getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return String.valueOf(cal.get(1));
    }

    public static String getYearAndMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String value = sdf.format(date);
        return value.substring(0, 7);
    }

    public static Integer turnZnDayOfWeek(Integer day) {
        return (day = Integer.valueOf(day + 1)) > 7 ? day - 6 : day;
    }

    public static Integer turnZnDayOfMonth(Integer day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        if (day > cal.getActualMaximum(5)) {
            cal.add(5, 1);
            day = cal.get(5);
            return day;
        }
        return day == 30 ? cal.getActualMaximum(5) : day.intValue();
    }

    public static String formatDateString(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat bsdf = new SimpleDateFormat(DateUtil.getDateFormat(str));
        String dateStr = null;
        try {
            dateStr = sdf.format(bsdf.parse(str));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if (!year) {
            if (str.contains("\u6708") || str.contains("-") || str.contains("/")) {
                if (Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            } else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            char lastChar;
            char chr = str.charAt(i);
            if (Character.isDigit(chr)) {
                if (index == 0) {
                    sb.append("y");
                }
                if (index == 1) {
                    sb.append("M");
                }
                if (index == 2) {
                    sb.append("d");
                }
                if (index == 3) {
                    sb.append("H");
                }
                if (index == 4) {
                    sb.append("m");
                }
                if (index == 5) {
                    sb.append("s");
                }
                if (index != 6) continue;
                sb.append("S");
                continue;
            }
            if (i > 0 && Character.isDigit(lastChar = str.charAt(i - 1))) {
                ++index;
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

