package com.ejianc.business.income.history;

import com.ejianc.business.income.vo.SupplementVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SupplementHistoryVo extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;
    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;
    /**
     * 初始版本金额（含税）
     */
    private BigDecimal baseTaxMoney;
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;
    //累计变更金额
    private BigDecimal sumChangeMny;

    //累计变更率
    private BigDecimal sumScale;
    private Integer isFinish;

    private List<SupplementVO> detailList = new ArrayList<>();

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getSumScale() {
        return sumScale;
    }

    public void setSumScale(BigDecimal sumScale) {
        this.sumScale = sumScale;
    }

    public List<SupplementVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SupplementVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getSumChangeMny() {
        return sumChangeMny;
    }

    public void setSumChangeMny(BigDecimal sumChangeMny) {
        this.sumChangeMny = sumChangeMny;
    }

}
