package com.ejianc.business.income.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.income.vo.SupplementDetailVO;
import com.ejianc.business.income.vo.SupplementClauseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 补充协议实体
 *
 * @author generator
 *
 */
public class SupplementVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private Long orgId; // 组织
    private String contractName; // 合同名称
    private String billCode; // 单据编号
    private Integer contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    private Long customerId; // 发包单位
    private Long contractorUnit; // 承包单位,
    private Integer type; // 经营方式：1-自营，2-联营
    private BigDecimal manageChargeRate; // 管理费比例,联营时展示，自营时不展示
    private BigDecimal taxRate; // 合同税率
    private Long contractValuationType; // 合同计价形式，档案
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签约日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
    private Integer term; // 总工期
    private Long employeeId; // 经办人
    private String memo; // 备注
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal taxMny; // 税金
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private BigDecimal baseMoney; // 初始版本金额
    private BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal changingTaxMny; // 变更中金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private Integer changeVersion; // 变更版本
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer billState; // 单据状态
    private String projectName; // 项目名称
    private String customerName; // 发包单位名称
    private String contractorUnitName; // 承包单位名称
    private String employeeName; // 经办人名称
    private String orgName; // 组织名称
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    private BigDecimal sumProductionMny; // 累计产值报量
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    private BigDecimal sumQuoteMny; // 累计甲方报量
    private BigDecimal sumCollectMny; // 累计收款
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private BigDecimal sumInvoicingMny; // 累计开票
    private BigDecimal sumClaimMny; // 累计变更洽商
    /**
     * 累计变更洽商
     */
    private BigDecimal sumClaimTaxMny;
    private String changeReason; // 变更原因
    private String mainContractName; // 主合同名称
    private Long mainContractId; // 主合同ID
    private String mainContractCode; // 主合同编码
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)

    private List<SupplementDetailVO> checkList = new ArrayList<>(); // 补充协议清单
    private List<SupplementClauseVO> clauseList = new ArrayList<>(); // 补充协议条款

    public BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    public void setSumClaimTaxMny(BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }

    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public Integer getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 发包单位
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 发包单位
     */
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 承包单位,
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    /**
     * 承包单位,
     */
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    /**
     * 经营方式：1-自营，2-联营
     */
    public Integer getType() {
        return type;
    }

    /**
     * 经营方式：1-自营，2-联营
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 签约日期
     */
    public Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 开工日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 开工日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 竣工日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 竣工日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 总工期
     */
    public Integer getTerm() {
        return term;
    }

    /**
     * 总工期
     */
    public void setTerm(Integer term) {
        this.term = term;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 税金
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 初始版本金额（含税）
     */
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    /**
     * 初始版本金额（含税）
     */
    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发包单位名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 发包单位名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 承包单位名称
     */
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    /**
     * 承包单位名称
     */
    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 累计产值报量
     */
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计甲方报量（含税）
     */
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 累计甲方报量
     */
    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计甲方报量
     */
    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计收款
     */
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    /**
     * 累计收款
     */
    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    /**
     * 累计开票（含税）
     */
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计开票（含税）
     */
    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计开票
     */
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计开票
     */
    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    /**
     * 累计变更洽商
     */
    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    /**
     * 累计变更洽商
     */
    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 主合同ID
     */
    @ReferSerialTransfer(referCode="income-contract")
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同ID
     */
    @ReferDeserialTransfer
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

     /**
      * 补充协议清单
      */
     public List<SupplementDetailVO> getCheckList() {
        return checkList;
     }

     /**
      * 补充协议清单
      */
     public void setCheckList(List<SupplementDetailVO> checkList) {
        this.checkList = checkList;
     }
     /**
      * 补充协议条款
      */
     public List<SupplementClauseVO> getClauseList() {
        return clauseList;
     }

     /**
      * 补充协议条款
      */
     public void setClauseList(List<SupplementClauseVO> clauseList) {
        this.clauseList = clauseList;
     }
}
