package com.ejianc.business.income.api;

import com.ejianc.business.income.hystrix.ContractReportHystrix;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(name = "ejc-income-web", url = "${common.env.feign-client-url}", path = "ejc-income-web", fallback = ContractReportHystrix.class)
public interface IContractReportApi {
    /**
     * 查起始日期和结束日期
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/report/projectMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectReportVo> projectMonth(@RequestParam(value = "projectId") Long projectId,
                                                        @RequestParam(value = "lastDay") Integer lastDay);

    /**
     * 根据项目查合同总金额
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/report/sumContractMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查产值
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/report/getMonthProductionMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProductionMny(@RequestParam(value = "projectId") Long projectId,
                                                                       @RequestParam(value = "lastDay") Integer lastDay);

    /**
     * 查收入数据
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/report/getIncomeMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IncomeReportMnyVo> getIncomeMny(@RequestParam(value = "projectId") Long projectId);

    /**
     * 查月度产值
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/report/getMonthProduction", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProduction(@RequestParam(value = "projectId") Long projectId);
}
