package com.ejianc.business.income.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 产值计划
 * 
 * @author generator
 * 
 */
public class ProductionPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private String billCode; // 单据编号
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private java.math.BigDecimal taxRate; // 合同税率
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String planMonth; // 计划月份
    private java.math.BigDecimal planMny; // 本月计划产值(不含税)
    private java.math.BigDecimal planTaxMny; // 本月计划产值(含税)
    private java.math.BigDecimal thisPlanTaxMny; // 本月计划产值税金
    private java.math.BigDecimal planRate; // 占合同比例
    private java.math.BigDecimal yearPlanTaxMny; // 本年计划产值(含税)
    private java.math.BigDecimal yearPlanMny; // 本年计划产值(不含税)
    private java.math.BigDecimal thisYearTaxMny; // 本年计划产值税金
    private String planProgress; // 本月计划形象
    private String otherExplain; // 其他说明
    private String createUserName; // 创建者名称
    private Long employeeId; // 经办人主键
    private String employeeName; // 经办人名称

    private Integer contractVersion;
    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 计划月份
     */
    public String getPlanMonth() {
        return planMonth;
    }

    /**
     * 计划月份
     */
    public void setPlanMonth(String planMonth) {
        this.planMonth = planMonth;
    }
    /**
     * 本月计划产值(不含税)
     */
    public java.math.BigDecimal getPlanMny() {
        return planMny;
    }

    /**
     * 本月计划产值(不含税)
     */
    public void setPlanMny(java.math.BigDecimal planMny) {
        this.planMny = planMny;
    }
    /**
     * 本月计划产值(含税)
     */
    public java.math.BigDecimal getPlanTaxMny() {
        return planTaxMny;
    }

    /**
     * 本月计划产值(含税)
     */
    public void setPlanTaxMny(java.math.BigDecimal planTaxMny) {
        this.planTaxMny = planTaxMny;
    }
    /**
     * 本月计划产值税金(待定)
     */
    public java.math.BigDecimal getThisPlanTaxMny() {
        return thisPlanTaxMny;
    }

    /**
     * 本月计划产值税金(待定)
     */
    public void setThisPlanTaxMny(java.math.BigDecimal thisPlanTaxMny) {
        this.thisPlanTaxMny = thisPlanTaxMny;
    }
    /**
     * 占合同比例
     */
    public java.math.BigDecimal getPlanRate() {
        return planRate;
    }

    /**
     * 占合同比例
     */
    public void setPlanRate(java.math.BigDecimal planRate) {
        this.planRate = planRate;
    }
    /**
     * 本年计划产值(含税)
     */
    public java.math.BigDecimal getYearPlanTaxMny() {
        return yearPlanTaxMny;
    }

    /**
     * 本年计划产值(含税)
     */
    public void setYearPlanTaxMny(java.math.BigDecimal yearPlanTaxMny) {
        this.yearPlanTaxMny = yearPlanTaxMny;
    }
    /**
     * 本年计划产值(不含税)
     */
    public java.math.BigDecimal getYearPlanMny() {
        return yearPlanMny;
    }

    /**
     * 本年计划产值(不含税)
     */
    public void setYearPlanMny(java.math.BigDecimal yearPlanMny) {
        this.yearPlanMny = yearPlanMny;
    }
    /**
     * 本年计划产值税金(待定)
     */
    public java.math.BigDecimal getThisYearTaxMny() {
        return thisYearTaxMny;
    }

    /**
     * 本年计划产值税金(待定)
     */
    public void setThisYearTaxMny(java.math.BigDecimal thisYearTaxMny) {
        this.thisYearTaxMny = thisYearTaxMny;
    }
    /**
     * 本月计划形象
     */
    public String getPlanProgress() {
        return planProgress;
    }

    /**
     * 本月计划形象
     */
    public void setPlanProgress(String planProgress) {
        this.planProgress = planProgress;
    }
    /**
     * 其他说明
     */
    public String getOtherExplain() {
        return otherExplain;
    }

    /**
     * 其他说明
     */
    public void setOtherExplain(String otherExplain) {
        this.otherExplain = otherExplain;
    }

    /**
     * 创建者名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建者名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 经办人主键
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人主键
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
