package com.ejianc.business.other.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.other.vo.OtherClauseVO;
import com.ejianc.business.other.vo.OtherDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
public class OtherContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long projectId; // 项目
    private java.lang.Long orgId; // 组织
    private java.lang.String contractName; // 合同名称
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    private java.lang.Long customerId; // 发包单位
    private java.lang.Long contractorUnit; // 承包单位,
    private java.lang.Integer type; // 经营方式：1-自营，2-联营
    private java.math.BigDecimal manageChargeRate; // 管理费比例,联营时展示，自营时不展示
    private java.math.BigDecimal taxRate; // 合同税率
    private java.lang.Long contractValuationType; // 合同计价形式，档案
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 竣工日期
    private java.lang.Integer term; // 总工期
    private java.lang.Long employeeId; // 经办人
    private java.lang.String memo; // 备注
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private java.math.BigDecimal baseMoney; // 初始版本金额
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private java.math.BigDecimal beforeChangeMny; // 变更前金额
    private java.math.BigDecimal changingTaxMny; // 变更中金额（含税）
    private java.math.BigDecimal changingMny; // 变更中金额
    private java.lang.Integer changeVersion; // 变更版本
    private java.lang.Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private java.lang.String changeCode; // 变更单号
    private java.lang.Long changeId; // 变更主键
    private java.lang.Integer billState; // 单据状态
    private java.lang.String projectName; // 项目名称
    private java.lang.String customerName; // 发包单位名称
    private java.lang.String contractorUnitName; // 承包单位名称
    private java.lang.String employeeName; // 经办人名称
    private java.lang.String orgName; // 组织名称
    private java.math.BigDecimal sumProductionTaxMny; // 累计产值报量
    private java.math.BigDecimal sumProductionMny; // 累计产值报量
    private java.math.BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    private java.math.BigDecimal sumQuoteMny; // 累计甲方报量
    private java.math.BigDecimal sumCollectMny; // 累计收款
    private java.math.BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private java.math.BigDecimal sumInvoicingMny; // 累计开票
    private java.math.BigDecimal sumClaimMny; // 累计变更洽商
    private java.lang.String changeReason; // 变更原因
    private java.lang.String mainContractName; // 主合同名称
    private java.lang.Long mainContractId; // 主合同ID
    private java.lang.String mainContractCode; // 主合同编码
    private java.lang.Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private java.lang.Integer isFinish; // 是否已做竣工结算(1:是，0：否)
    private java.math.BigDecimal sumClaimTaxMny; // 累计变更洽商
    private java.lang.Integer warrantyPeriod; // 保修期（月份）
    private java.lang.String billType; // 合同标识(income-施工合同,other-其他收入合同，all - 不区别)
    
    private List<OtherClauseVO> clauseList = new ArrayList<>(); // 其他收入合同条款
    private List<OtherDetailVO> checkList = new ArrayList<>(); // 其他收入合同清单

    private String contractStatusName;
    private String billStateName;

    public String getContractStatusName() {
        return contractStatusName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    @ReferSerialTransfer(referCode="income-contract")
    public Long getMainContractId() {
        return mainContractId;
    }

    @ReferDeserialTransfer
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public java.lang.Integer getIsFinish() {
        return isFinish;
    }

    /**
     * 是否已做竣工结算(1:是，0：否)
     */
    public void setIsFinish(java.lang.Integer isFinish) {
        this.isFinish = isFinish;
    }
    /**
     * 累计变更洽商
     */
    public java.math.BigDecimal getSumClaimTaxMny() {
        return sumClaimTaxMny;
    }

    /**
     * 累计变更洽商
     */
    public void setSumClaimTaxMny(java.math.BigDecimal sumClaimTaxMny) {
        this.sumClaimTaxMny = sumClaimTaxMny;
    }
    /**
     * 保修期（月份）
     */
    public java.lang.Integer getWarrantyPeriod() {
        return warrantyPeriod;
    }

    /**
     * 保修期（月份）
     */
    public void setWarrantyPeriod(java.lang.Integer warrantyPeriod) {
        this.warrantyPeriod = warrantyPeriod;
    }
    /**
     * 合同标识(income-施工合同,other-其他收入合同，all - 不区别)
     */
    public java.lang.String getBillType() {
        return billType;
    }

    /**
     * 合同标识(income-施工合同,other-其他收入合同，all - 不区别)
     */
    public void setBillType(java.lang.String billType) {
        this.billType = billType;
    }

    public List<OtherClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<OtherClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<OtherDetailVO> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<OtherDetailVO> checkList) {
        this.checkList = checkList;
    }

    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
}
