package com.ejianc.business.income.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 竣工结算
 * 
 * @author generator
 * 
 */
public class FinishVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private Long contractId; // 合同id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settleDate; // 结算日期
    private Long orgId; // 组织
    private String contractName; // 合同名称
    private String billCode; // 单据编号
    private Integer contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    private Long customerId; // 发包单位
    private Long contractorUnit; // 承包单位,
    private Integer type; // 经营方式：1-自营，2-联营
    private java.math.BigDecimal manageChargeRate; // 管理费比例,联营时展示，自营时不展示
    private java.math.BigDecimal taxRate; // 合同税率
    private Long contractValuationType; // 合同计价形式，档案
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 竣工日期
    private Integer term; // 总工期
    private Long employeeId; // 经办人
    private String memo; // 备注
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private Integer billState; // 单据状态
    private String projectName; // 项目名称
    private String customerName; // 发包单位名称
    private String contractorUnitName; // 承包单位名称
    private String employeeName; // 经办人名称
    private String orgName; // 组织名称
    private java.math.BigDecimal sumProductionTaxMny; // 累计产值报量
    private java.math.BigDecimal sumProductionMny; // 累计产值报量
    private java.math.BigDecimal sumSettleTaxMny; // 累计结算金额（含税）
    private java.math.BigDecimal sumSettleMny; // 累计结算金额
    private java.math.BigDecimal sumSettleCutMny; // 结算差额
    private java.math.BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    private java.math.BigDecimal sumQuoteMny; // 累计甲方报量
    private java.math.BigDecimal sumCollectMny; // 累计收款
    private java.math.BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    private java.math.BigDecimal sumInvoicingMny; // 累计开票
    private java.math.BigDecimal sumClaimMny; // 累计变更洽商

    private String billStateName;
    private java.lang.String sourceId;
    private java.lang.Long deptId;
    private java.lang.String deptName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 竣工日期

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode = "income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    /**
     * 结算日期
     */
    public java.util.Date getSettleDate() {
        return settleDate;
    }

    /**
     * 结算日期
     */
    public void setSettleDate(java.util.Date settleDate) {
        this.settleDate = settleDate;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public Integer getContractStatus() {
        return contractStatus;
    }

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    /**
     * 发包单位
     */
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * 发包单位
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 承包单位,
     */
    public Long getContractorUnit() {
        return contractorUnit;
    }

    /**
     * 承包单位,
     */
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    /**
     * 经营方式：1-自营，2-联营
     */
    public Integer getType() {
        return type;
    }

    /**
     * 经营方式：1-自营，2-联营
     */
    public void setType(Integer type) {
        this.type = type;
    }
    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public java.math.BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    public void setManageChargeRate(java.math.BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }
    /**
     * 合同税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同计价形式，档案
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式，档案
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 签约日期
     */
    public java.util.Date getSignDate() {
        return signDate;
    }

    /**
     * 签约日期
     */
    public void setSignDate(java.util.Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 开工日期
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 开工日期
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 竣工日期
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 竣工日期
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 总工期
     */
    public Integer getTerm() {
        return term;
    }

    /**
     * 总工期
     */
    public void setTerm(Integer term) {
        this.term = term;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 税金
     */
    public java.math.BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税金
     */
    public void setTaxMny(java.math.BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 合同金额(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发包单位名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 发包单位名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 承包单位名称
     */
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    /**
     * 承包单位名称
     */
    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 累计产值报量
     */
    public java.math.BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionTaxMny(java.math.BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 累计产值报量
     */
    public java.math.BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值报量
     */
    public void setSumProductionMny(java.math.BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计结算金额（含税）
     */
    public java.math.BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    /**
     * 累计结算金额（含税）
     */
    public void setSumSettleTaxMny(java.math.BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }
    /**
     * 累计结算金额
     */
    public java.math.BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    /**
     * 累计结算金额
     */
    public void setSumSettleMny(java.math.BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    /**
     * 结算差额
     */
    public java.math.BigDecimal getSumSettleCutMny() {
        return sumSettleCutMny;
    }

    /**
     * 结算差额
     */
    public void setSumSettleCutMny(java.math.BigDecimal sumSettleCutMny) {
        this.sumSettleCutMny = sumSettleCutMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public java.math.BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    /**
     * 累计甲方报量（含税）
     */
    public void setSumQuoteTaxMny(java.math.BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    /**
     * 累计甲方报量
     */
    public java.math.BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    /**
     * 累计甲方报量
     */
    public void setSumQuoteMny(java.math.BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    /**
     * 累计收款
     */
    public java.math.BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    /**
     * 累计收款
     */
    public void setSumCollectMny(java.math.BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    /**
     * 累计开票（含税）
     */
    public java.math.BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    /**
     * 累计开票（含税）
     */
    public void setSumInvoicingTaxMny(java.math.BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    /**
     * 累计开票
     */
    public java.math.BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    /**
     * 累计开票
     */
    public void setSumInvoicingMny(java.math.BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    /**
     * 累计变更洽商
     */
    public java.math.BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    /**
     * 累计变更洽商
     */
    public void setSumClaimMny(java.math.BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
}
