package com.ejianc.business.inother.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 其他收入合同变更实体
 * 
 * @author generator
 * 
 */
public class OtherChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Long contractId; // 合同主键
    private java.lang.Long projectId; // 项目
    private java.lang.Long orgId; // 组织
    private java.lang.String contractName; // 合同名称
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer contractStatus; // 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
    private java.lang.Long customerId; // 发包单位
    private java.lang.Long contractorUnit; // 承包单位
    private java.lang.Integer type; // 经营方式：1-自营，2-联营
    private java.math.BigDecimal manageChargeRate; // 管理费比例,联营时展示，自营时不展示
    private java.math.BigDecimal taxRate; // 合同税率
    private java.lang.Long contractValuationType; // 合同计价形式，档案
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date signDate; // 签约日期
    private java.util.Date startDate; // 开工日期
    private java.util.Date endDate; // 竣工日期
    private java.lang.Integer term; // 总工期
    private java.lang.Long employeeId; // 经办人
    private java.lang.String memo; // 备注
    private java.math.BigDecimal contractTaxMny; // 合同金额
    private java.math.BigDecimal taxMny; // 税金
    private java.math.BigDecimal contractMny; // 合同金额(不含税)
    private java.math.BigDecimal baseTaxMoney; // 初始版本金额（含税）
    private java.math.BigDecimal baseMoney; // 初始版本金额
    private java.math.BigDecimal beforeChangeTaxMny; // 变更前金额（含税）
    private java.math.BigDecimal beforeChangeMny; // 变更前金额
    private java.lang.Integer changeVersion; // 变更版本
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date changeTime; // 变更（编制）时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date usedTime; // 生效时间
    private java.lang.Integer billState; // 单据状态
    private java.lang.String projectName; // 项目名称
    private java.lang.String customerName; // 发包单位名称
    private java.lang.String contractorUnitName; // 承包单位名称
    private java.lang.String employeeName; // 经办人名称
    private java.lang.String beforeContractName; // 变更前合同名称
    private java.lang.String orgName; // 组织名称
    private java.lang.String changeReason; // 变更原因
    private java.lang.String mainContractName; // 主合同名称
    private java.lang.Long mainContractId; // 主合同ID
    private java.lang.String mainContractCode; // 主合同编码
    private java.lang.Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private java.lang.String billType; // 合同标识(income-施工合同,other-其他收入合同)

    private List<OtherChangeDetailVO> checkList = new ArrayList<>();// 其他收入合同变更-清单
    private List<OtherChangeClauseVO> clauseList = new ArrayList<>();// 其他收入合同变更-条款
    //历史版本编号
    private String historyBillCode;
    //本次变更比例
    private BigDecimal scale;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getContractorUnit() {
        return contractorUnit;
    }
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 合同标识(income-施工合同,other-其他收入合同)
     */
    public java.lang.String getBillType() {
        return billType;
    }

    /**
     * 合同标识(income-施工合同,other-其他收入合同)
     */
    public void setBillType(java.lang.String billType) {
        this.billType = billType;
    }

    public List<OtherChangeDetailVO> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<OtherChangeDetailVO> checkList) {
        this.checkList = checkList;
    }

    public List<OtherChangeClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<OtherChangeClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
}
