package com.ejianc.business.income.api;

import com.ejianc.business.income.hystrix.IncomeBlocKanBanHystrix;
import com.ejianc.business.income.vo.BlocKanBanVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @ClassName: BlocKanBanApi
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/3 10:57
 */
@FeignClient(name = "ejc-income-web", url = "${common.env.feign-client-url}", path = "ejc-income-web", fallback = IncomeBlocKanBanHystrix.class)
public interface IIncomeBlocKanBanApi {

    /**
     * 集团看板top5
     * @param productionFlag 0-产值金额(默认)，1-产值完成率
     * @param yearFlag 0-今年(默认)，1-全年
     * @return
     */
    @RequestMapping(value = "/api/blocKanBan/queryProduction", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<BlocKanBanVo>> queryProduction(@RequestParam(value = "orgId", required = false) Long orgId
            , @RequestParam(value = "productionFlag") Integer productionFlag, @RequestParam(value = "yearFlag") Integer yearFlag);



}
