package com.ejianc.business.income.history;

import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ProductionPlanHistoryVo extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;
    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)

    /**
     * 施工合同总金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 累计月产值计划金额
     */
    private BigDecimal totalPlanTaxMny;

    /**
     * 占合同比例
     */
    private BigDecimal totalPlanRate;

    private List<ProductionPlanVO> productionPlanRecord = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTotalPlanTaxMny() {
        return totalPlanTaxMny;
    }

    public void setTotalPlanTaxMny(BigDecimal totalPlanTaxMny) {
        this.totalPlanTaxMny = totalPlanTaxMny;
    }

    public BigDecimal getTotalPlanRate() {
        return totalPlanRate;
    }

    public void setTotalPlanRate(BigDecimal totalPlanRate) {
        this.totalPlanRate = totalPlanRate;
    }

    public List<ProductionPlanVO> getProductionPlanRecord() {
        return productionPlanRecord;
    }

    public void setProductionPlanRecord(List<ProductionPlanVO> productionPlanRecord) {
        this.productionPlanRecord = productionPlanRecord;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }
}
