package com.ejianc.business.income.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 补充协议清单
 *
 * @author generator
 *
 */
public class SupplementDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 施工合同主键
    private String detailIndex; // 序号
    private String code; // 清单编号
    private Long parentId; // parent_id
    private String name; // 清单名称
    private String unit; // 计量单位
    private java.math.BigDecimal num; // 工程量
    private java.math.BigDecimal price; // 综合单价（无税）
    private java.math.BigDecimal mny; // 合价（无税）
    private String memo; // 备注
    private Boolean leafFlag; // 是否末级
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    private Long srcSupplementId; // 来源补充协议主表ID
    private Long srcSupplementDetailId; // 来源补充协议明细ID

    /**
     * 税率
     */
    private BigDecimal detailTaxRate;

    /**
     * 综合单价
     */
    private BigDecimal detailTaxPrice;

    /**
     * 合价
     */
    private BigDecimal detailTaxMny;
    /**
     * 税额
     */
    private BigDecimal detailTax;

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    /**
     * 施工合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 施工合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 综合单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 综合单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 合价
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 合价
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }
    /**
     * 来源补充协议主表ID
     */
    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    /**
     * 来源补充协议主表ID
     */
    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }
    /**
     * 来源补充协议明细ID
     */
    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    /**
     * 来源补充协议明细ID
     */
    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }
}
