package com.ejianc.business.income.vo.report;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class ProductionCountVO  {
    private Long projectId;
    private Long tenantId;
    private Long projectDepartmentId;
    private Long orgId;

    private String countMonth;// 当前月份

    /**
     * 项目相关
     */
    private String projectCode; // 项目编号
    private String projectName; //工程名称
    private String pubUnitName; //建设单位
    private String area; //工程地点
    private String investorName; //投资方式
    private String projectOverview; //工程概况
    private String engineeringTypeName; //工程类别
    private String contractualModelName; //承揽类型
    private String type; //管理模式
    private String contractorUnitName; //中标单位
    private String projectManagerName; //项目经理
    private String signDate; //中标日期
    private String status; //工程状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String plannedCommencementDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String plannedFinishDate; // 计划竣工日期
    
    /**
     * 合同相关
     */
    private Long contractId;//合同主键
    private String contractName;//合同
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;// 合同开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;// 合同结束时间
    private BigDecimal contractTaxMny;// 合同金额

    /**
     * 产值计划相关
     */
    private BigDecimal planTaxMny;// 本月产值计划
    private BigDecimal nextPlanTaxMny;// 下月产值计划
    private String nextPlanProgress;// 下月计划形象进度说明

    /**
     * 产值进度相关
     */
    private BigDecimal finishTaxMny; //本月完成产值
    private BigDecimal finshRate; //完成月度计划比例
    private String satisfyFlag; //本期进展情况是否符合要求
    private String visualProgress; //形象进度说明
    private String existProblem; //工程目前存在问题
    private BigDecimal yearPlanTaxMny; //本年度计划完成产值
    private BigDecimal yearFinishTaxMny; //本年累计完成产值
    private BigDecimal totalFinishTaxMny; //自开工累计产值
    private String allVisualProgress; //总体形象进度完成情况
    private String evaluateState; //整体进度评价情况
    private String lagExplain; //滞后原因说明
    private BigDecimal totalFinishRate; //自开工累计完成占合同额比例

    /**
     * 甲方批量
     */
    private BigDecimal yearQuoteTaxMny; //合同内本年度累计已确认产值(本年至本月的累计)
    private BigDecimal quoteTaxMny;// 合同已确认产值
    private BigDecimal totalQuoteTaxMny;//合同内开工累计已确认产值

    /**
     * 签证洽商索赔
     */
    private BigDecimal sumOccurMny;//累计发生金额
    private BigDecimal sumReplyMny;//累计确认金额
    private BigDecimal outClaimMny;//合同外已发生未确认产值（发生金额-确认金额）

    /**
     * 收入管理
     */
    private BigDecimal receiveMny;//本月收回工程款
    private BigDecimal sumReceiveMny;//累计收回工程款
    private BigDecimal sumReceiveRate;//已收款占累计完成产值比例(累计收回工程款/自开工累计产值)

    //导出翻译
    private String typeName;
    private String statusName;
    private String evaluateStateName;
    private String satisfyFlagName;
    // -----------------

    /**
     * 竣工结算
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 竣工日期
    

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getEvaluateStateName() {
        return evaluateStateName;
    }

    public void setEvaluateStateName(String evaluateStateName) {
        this.evaluateStateName = evaluateStateName;
    }

    public String getSatisfyFlagName() {
        return satisfyFlagName;
    }

    public void setSatisfyFlagName(String satisfyFlagName) {
        this.satisfyFlagName = satisfyFlagName;
    }

    public BigDecimal getSumReceiveRate() {
        return sumReceiveRate;
    }

    public void setSumReceiveRate(BigDecimal sumReceiveRate) {
        this.sumReceiveRate = sumReceiveRate;
    }

    public String getCountMonth() {
        return countMonth;
    }

    public void setCountMonth(String countMonth) {
        this.countMonth = countMonth;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }

    public BigDecimal getSumOccurMny() {
        return sumOccurMny;
    }

    public void setSumOccurMny(BigDecimal sumOccurMny) {
        this.sumOccurMny = sumOccurMny;
    }

    public BigDecimal getSumReplyMny() {
        return sumReplyMny;
    }

    public void setSumReplyMny(BigDecimal sumReplyMny) {
        this.sumReplyMny = sumReplyMny;
    }

    public BigDecimal getOutClaimMny() {
        return outClaimMny;
    }

    public void setOutClaimMny(BigDecimal outClaimMny) {
        this.outClaimMny = outClaimMny;
    }

    public BigDecimal getYearQuoteTaxMny() {
        return yearQuoteTaxMny;
    }

    public void setYearQuoteTaxMny(BigDecimal yearQuoteTaxMny) {
        this.yearQuoteTaxMny = yearQuoteTaxMny;
    }

    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }

    public BigDecimal getTotalQuoteTaxMny() {
        return totalQuoteTaxMny;
    }

    public void setTotalQuoteTaxMny(BigDecimal totalQuoteTaxMny) {
        this.totalQuoteTaxMny = totalQuoteTaxMny;
    }

    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }

    public BigDecimal getFinshRate() {
        return finshRate;
    }

    public void setFinshRate(BigDecimal finshRate) {
        this.finshRate = finshRate;
    }

    public String getSatisfyFlag() {
        return satisfyFlag;
    }

    public void setSatisfyFlag(String satisfyFlag) {
        this.satisfyFlag = satisfyFlag;
    }

    public String getVisualProgress() {
        return visualProgress;
    }

    public void setVisualProgress(String visualProgress) {
        this.visualProgress = visualProgress;
    }

    public String getExistProblem() {
        return existProblem;
    }

    public void setExistProblem(String existProblem) {
        this.existProblem = existProblem;
    }

    public BigDecimal getYearPlanTaxMny() {
        return yearPlanTaxMny;
    }

    public void setYearPlanTaxMny(BigDecimal yearPlanTaxMny) {
        this.yearPlanTaxMny = yearPlanTaxMny;
    }

    public BigDecimal getYearFinishTaxMny() {
        return yearFinishTaxMny;
    }

    public void setYearFinishTaxMny(BigDecimal yearFinishTaxMny) {
        this.yearFinishTaxMny = yearFinishTaxMny;
    }

    public BigDecimal getTotalFinishTaxMny() {
        return totalFinishTaxMny;
    }

    public void setTotalFinishTaxMny(BigDecimal totalFinishTaxMny) {
        this.totalFinishTaxMny = totalFinishTaxMny;
    }

    public String getAllVisualProgress() {
        return allVisualProgress;
    }

    public void setAllVisualProgress(String allVisualProgress) {
        this.allVisualProgress = allVisualProgress;
    }

    public String getEvaluateState() {
        return evaluateState;
    }

    public void setEvaluateState(String evaluateState) {
        this.evaluateState = evaluateState;
    }

    public String getLagExplain() {
        return lagExplain;
    }

    public void setLagExplain(String lagExplain) {
        this.lagExplain = lagExplain;
    }

    public BigDecimal getTotalFinishRate() {
        return totalFinishRate;
    }

    public void setTotalFinishRate(BigDecimal totalFinishRate) {
        this.totalFinishRate = totalFinishRate;
    }

    public BigDecimal getNextPlanTaxMny() {
        return nextPlanTaxMny;
    }

    public void setNextPlanTaxMny(BigDecimal nextPlanTaxMny) {
        this.nextPlanTaxMny = nextPlanTaxMny;
    }

    public String getNextPlanProgress() {
        return nextPlanProgress;
    }

    public void setNextPlanProgress(String nextPlanProgress) {
        this.nextPlanProgress = nextPlanProgress;
    }

    public BigDecimal getPlanTaxMny() {
        return planTaxMny;
    }

    public void setPlanTaxMny(BigDecimal planTaxMny) {
        this.planTaxMny = planTaxMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getSignDate() {
        return signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(String plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public String getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(String plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
}
