package com.ejianc.business.income.paln.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 年度计划
 * 
 * @author generator
 * 
 */
public class YearPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long createUserId; // 创建者账号
    private String billCode; // 单据编码
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date planDate; // 年度
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private BigDecimal contractTax; // 合同税率
    private BigDecimal yearProductionTaxMny; // 本年计划产值
    private BigDecimal yearProductionMny; // 本年计划产值(无税)
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办（申请人）部门id
    private String departmentName; // 经办（申请人）部门名称
    private String memo; // 备注

    private String billStateStr;
    private String planDateStr;

    public String getPlanDateStr() {
        return planDateStr;
    }

    public void setPlanDateStr(String planDateStr) {
        this.planDateStr = planDateStr;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    private List<YearPlanDetailVO> detailList = new ArrayList<>(); // 年度计划详情

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getYearProductionTaxMny() {
        return yearProductionTaxMny;
    }

    public void setYearProductionTaxMny(BigDecimal yearProductionTaxMny) {
        this.yearProductionTaxMny = yearProductionTaxMny;
    }
    public BigDecimal getYearProductionMny() {
        return yearProductionMny;
    }

    public void setYearProductionMny(BigDecimal yearProductionMny) {
        this.yearProductionMny = yearProductionMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<YearPlanDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<YearPlanDetailVO> detailList) {
        this.detailList = detailList;
     }
}
