package com.ejianc.business.income.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

public class CostWarningVo {
	
	private Long id;
    private Long tenantId;
    private Long projectDepartmentId;
    private Long orgId;
    private String orgName;
    private String dr;
    private Long deptId;
    
    /**
     * 项目相关
     */
    private String name; //工程名称
    
    /**
     * 合同相关
     */
    private BigDecimal contractTaxMny;// 合同金额
    private Long contractId;//合同主鍵
    private String contractName;//合同名称
    
    private String type;//项目类型
    
    private String typeText;//项目类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;//项目开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;//项目预计竣工时间
    
    private BigDecimal productionMny;//累计产值
    
    private BigDecimal responsibilityCost;//目标责任成本
    
    private BigDecimal costMny;//实际成本
    
    private BigDecimal TargetProfit;//目标利润率
    
    private BigDecimal cbpc;//成本偏差
    private String cbWarning;//是否成本预警
    private BigDecimal gclr;//过程利润
    private BigDecimal gclrl;//过程利润率
    private BigDecimal lrlpc;//利润率偏差
    private String lrlWarning;//是否利润预警
    
    private String isCbWarning;//是否成本预警
    private String isLrWarning;//是否利润预警
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cbWarningDate;//成本预警时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lrWarningDate;//利润预警时间
    private String cbFilling;//是否成本消警
    private String lrFilling;//是否利润消警
    private Date cbFillingDate;//成本消警时间
    private Date lrFillingDate;//利润消警时间
    
    

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getDr() {
		return dr;
	}

	public void setDr(String dr) {
		this.dr = dr;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public BigDecimal getContractTaxMny() {
		return contractTaxMny;
	}

	public void setContractTaxMny(BigDecimal contractTaxMny) {
		this.contractTaxMny = contractTaxMny;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTypeText() {
		return typeText;
	}

	public void setTypeText(String typeText) {
		this.typeText = typeText;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public BigDecimal getProductionMny() {
		return productionMny;
	}

	public void setProductionMny(BigDecimal productionMny) {
		this.productionMny = productionMny;
	}

	public BigDecimal getResponsibilityCost() {
		return responsibilityCost;
	}

	public void setResponsibilityCost(BigDecimal responsibilityCost) {
		this.responsibilityCost = responsibilityCost;
	}

	public BigDecimal getCostMny() {
		return costMny;
	}

	public void setCostMny(BigDecimal costMny) {
		this.costMny = costMny;
	}

	public BigDecimal getTargetProfit() {
		return TargetProfit;
	}

	public void setTargetProfit(BigDecimal targetProfit) {
		TargetProfit = targetProfit;
	}

	public Long getContractId() {
		return contractId;
	}

	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}

	public BigDecimal getCbpc() {
		return cbpc;
	}

	public void setCbpc(BigDecimal cbpc) {
		this.cbpc = cbpc;
	}

	public BigDecimal getGclr() {
		return gclr;
	}

	public void setGclr(BigDecimal gclr) {
		this.gclr = gclr;
	}

	public BigDecimal getGclrl() {
		return gclrl;
	}

	public void setGclrl(BigDecimal gclrl) {
		this.gclrl = gclrl;
	}

	public BigDecimal getLrlpc() {
		return lrlpc;
	}

	public void setLrlpc(BigDecimal lrlpc) {
		this.lrlpc = lrlpc;
	}

	public String getCbWarning() {
		return cbWarning;
	}

	public void setCbWarning(String cbWarning) {
		this.cbWarning = cbWarning;
	}

	public String getLrlWarning() {
		return lrlWarning;
	}

	public void setLrlWarning(String lrlWarning) {
		this.lrlWarning = lrlWarning;
	}

	public String getContractName() {
		return contractName;
	}

	public void setContractName(String contractName) {
		this.contractName = contractName;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getIsCbWarning() {
		return isCbWarning;
	}

	public void setIsCbWarning(String isCbWarning) {
		this.isCbWarning = isCbWarning;
	}

	public String getIsLrWarning() {
		return isLrWarning;
	}

	public void setIsLrWarning(String isLrWarning) {
		this.isLrWarning = isLrWarning;
	}

	public Date getCbWarningDate() {
		return cbWarningDate;
	}

	public void setCbWarningDate(Date cbWarningDate) {
		this.cbWarningDate = cbWarningDate;
	}

	public Date getLrWarningDate() {
		return lrWarningDate;
	}

	public void setLrWarningDate(Date lrWarningDate) {
		this.lrWarningDate = lrWarningDate;
	}

	public String getCbFilling() {
		return cbFilling;
	}

	public void setCbFilling(String cbFilling) {
		this.cbFilling = cbFilling;
	}

	public String getLrFilling() {
		return lrFilling;
	}

	public void setLrFilling(String lrFilling) {
		this.lrFilling = lrFilling;
	}

	public Date getCbFillingDate() {
		return cbFillingDate;
	}

	public void setCbFillingDate(Date cbFillingDate) {
		this.cbFillingDate = cbFillingDate;
	}

	public Date getLrFillingDate() {
		return lrFillingDate;
	}

	public void setLrFillingDate(Date lrFillingDate) {
		this.lrFillingDate = lrFillingDate;
	}
    
    
}
