package com.ejianc.business.income.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 产值预警实体
 * 
 * @author generator
 * 
 */
public class IncomeWarningVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private BigDecimal contractTaxMny; // 合同金额
    private String countMonth; // 产值月份
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillingDate; // 消警时间
    private BigDecimal productionMonth; // 月度产值
    private BigDecimal productionPlanMoth; // 月度计划
    private BigDecimal productionSeason; // 季度产值
    private BigDecimal productionPlanSeason; // 季度计划
    private BigDecimal productionYear; // 年度产值
    private BigDecimal productionPlanYear; // 年度计划
    private BigDecimal productionScaleMonth; // 月度计划完成比例
    private BigDecimal productionScaleSeason; // 季度计划完成比例
    private BigDecimal productionScaleYear; // 年度计划完成比例
    private String warningMonth; // 月度预警级别
    private String warningSeason; // 季度预警级别
    private String warningYear; // 年度预警级别
    private String warningMonthStr; // 月度预警级别
    private String warningSeasonStr; // 季度预警级别
    private String warningYearStr; // 年度预警级别
    private String reason; // 原因分析
    private String measures; // 整改措施
    private Long orgId; // 组织
    private String billCode; // 单据编号
    private String memo; // 备注
    private String orgName; // 组织名称
    private String sourceId; // 来源主键
    private Long deptId; // 部门id
    private String deptName; // 部门名称
    private String progressMonth; // 月度形象进度
    private String progressSeason; // 季度形象进度
    private String progressYear; // 年度形象进度
    private String warningReason;
	public Integer getBillState() {
		return billState;
	}
	public void setBillState(Integer billState) {
		this.billState = billState;
	}
	public Long getProjectId() {
		return projectId;
	}
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
	public String getProjectName() {
		return projectName;
	}
	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}
	public Long getContractId() {
		return contractId;
	}
	public void setContractId(Long contractId) {
		this.contractId = contractId;
	}
	public String getContractName() {
		return contractName;
	}
	public void setContractName(String contractName) {
		this.contractName = contractName;
	}
	public BigDecimal getContractTaxMny() {
		return contractTaxMny;
	}
	public void setContractTaxMny(BigDecimal contractTaxMny) {
		this.contractTaxMny = contractTaxMny;
	}
	public String getCountMonth() {
		return countMonth;
	}
	public void setCountMonth(String countMonth) {
		this.countMonth = countMonth;
	}
	public Date getFillingDate() {
		return fillingDate;
	}
	public void setFillingDate(Date fillingDate) {
		this.fillingDate = fillingDate;
	}
	public BigDecimal getProductionMonth() {
		return productionMonth;
	}
	public void setProductionMonth(BigDecimal productionMonth) {
		this.productionMonth = productionMonth;
	}
	public BigDecimal getProductionPlanMoth() {
		return productionPlanMoth;
	}
	public void setProductionPlanMoth(BigDecimal productionPlanMoth) {
		this.productionPlanMoth = productionPlanMoth;
	}
	public BigDecimal getProductionSeason() {
		return productionSeason;
	}
	public void setProductionSeason(BigDecimal productionSeason) {
		this.productionSeason = productionSeason;
	}
	public BigDecimal getProductionPlanSeason() {
		return productionPlanSeason;
	}
	public void setProductionPlanSeason(BigDecimal productionPlanSeason) {
		this.productionPlanSeason = productionPlanSeason;
	}
	public BigDecimal getProductionYear() {
		return productionYear;
	}
	public void setProductionYear(BigDecimal productionYear) {
		this.productionYear = productionYear;
	}
	public BigDecimal getProductionPlanYear() {
		return productionPlanYear;
	}
	public void setProductionPlanYear(BigDecimal productionPlanYear) {
		this.productionPlanYear = productionPlanYear;
	}
	public BigDecimal getProductionScaleMonth() {
		return productionScaleMonth;
	}
	public void setProductionScaleMonth(BigDecimal productionScaleMonth) {
		this.productionScaleMonth = productionScaleMonth;
	}
	public BigDecimal getProductionScaleSeason() {
		return productionScaleSeason;
	}
	public void setProductionScaleSeason(BigDecimal productionScaleSeason) {
		this.productionScaleSeason = productionScaleSeason;
	}
	public BigDecimal getProductionScaleYear() {
		return productionScaleYear;
	}
	public void setProductionScaleYear(BigDecimal productionScaleYear) {
		this.productionScaleYear = productionScaleYear;
	}
	public String getWarningMonth() {
		return warningMonth;
	}
	public void setWarningMonth(String warningMonth) {
		this.warningMonth = warningMonth;
	}
	public String getWarningSeason() {
		return warningSeason;
	}
	public void setWarningSeason(String warningSeason) {
		this.warningSeason = warningSeason;
	}
	public String getWarningYear() {
		return warningYear;
	}
	public void setWarningYear(String warningYear) {
		this.warningYear = warningYear;
	}
	public String getReason() {
		return reason;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}
	public String getMeasures() {
		return measures;
	}
	public void setMeasures(String measures) {
		this.measures = measures;
	}
	public Long getOrgId() {
		return orgId;
	}
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
	public String getBillCode() {
		return billCode;
	}
	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}
	public String getMemo() {
		return memo;
	}
	public void setMemo(String memo) {
		this.memo = memo;
	}
	public String getOrgName() {
		return orgName;
	}
	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	public String getSourceId() {
		return sourceId;
	}
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
	public Long getDeptId() {
		return deptId;
	}
	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}
	public String getDeptName() {
		return deptName;
	}
	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}
	public String getProgressMonth() {
		return progressMonth;
	}
	public void setProgressMonth(String progressMonth) {
		this.progressMonth = progressMonth;
	}
	public String getProgressSeason() {
		return progressSeason;
	}
	public void setProgressSeason(String progressSeason) {
		this.progressSeason = progressSeason;
	}
	public String getProgressYear() {
		return progressYear;
	}
	public void setProgressYear(String progressYear) {
		this.progressYear = progressYear;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public String getWarningMonthStr() {
		if("0".equals(warningMonth)) {
			warningMonthStr="月度未填写数据";
		}else if("1".equals(warningMonth)) {
			warningMonthStr="月度黄色预警";
		}else if("2".equals(warningMonth)) {
			warningMonthStr="月度橙色预警";
		}else if("2".equals(warningMonth)) {
			warningMonthStr="月度红色预警";
		}
		return warningMonthStr;
	}
	public void setWarningMonthStr(String warningMonthStr) {
		this.warningMonthStr = warningMonthStr;
	}
	public String getWarningSeasonStr() {
		if("0".equals(warningSeason)) {
			warningSeasonStr="季度未填写数据";
		}else if("1".equals(warningSeason)) {
			warningSeasonStr="季度黄色预警";
		}else if("2".equals(warningSeason)) {
			warningSeasonStr="季度橙色预警";
		}else if("2".equals(warningSeason)) {
			warningSeasonStr="季度红色预警";
		}
		return warningSeasonStr;
	}
	public void setWarningSeasonStr(String warningSeasonStr) {
		this.warningSeasonStr = warningSeasonStr;
	}
	public String getWarningYearStr() {
		if("0".equals(warningYear)) {
			warningYearStr="年度未填写数据";
		}else if("1".equals(warningYear)) {
			warningYearStr="年度黄色预警";
		}else if("2".equals(warningYear)) {
			warningYearStr="年度橙色预警";
		}else if("2".equals(warningYear)) {
			warningYearStr="年度红色预警";
		}
		return warningYearStr;
	}
	public void setWarningYearStr(String warningYearStr) {
		this.warningYearStr = warningYearStr;
	}
	public String getWarningReason() {
		if(warningMonthStr !=null) {
			warningReason=warningReason+warningMonthStr;
		}
		if(warningSeasonStr !=null) {
			warningReason=warningReason+warningSeasonStr;
		}
		if(warningYearStr !=null) {
			warningReason=warningReason+warningYearStr;
		}
		return warningReason;
	}
	public void setWarningReason(String warningReason) {
		this.warningReason = warningReason;
	}
    

   
}
