package com.ejianc.business.income.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 产值进度
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public class ProjectProductionVo extends BaseVO {

    private static final long serialVersionUID = 1L;
    
   							
    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;
    
    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;
    
    /**
     * 租户
     */
    @TableField("tenant_id")
    private Long tenantId;
    
    /**
     * 本期完成产值（不含税）
     */
    @TableField("mny_bq")
    private BigDecimal mnyBq;
    
    /**
     * 本期完成产值（含税）
     */
    @TableField("tax_mny_bq")
    private BigDecimal taxMnyBq;
    
    
    /**
     *本期税金
     */
    @TableField("tax_bq")
    private BigDecimal taxBq;
    
    
    /**
     *同期完成产值（不含税）
     */
    @TableField("mny_tq")
    private BigDecimal mnytq;

    /**
     *同期完成产值（含税）
     */
    @TableField("tax_mny_tq")
    private BigDecimal taxMnytq;
    
    /**
     *同期税金
     */
    @TableField("tax_bq")
    private BigDecimal taxtq;
    
    /**
     *增长率
     */
    @TableField("zzl")
    private String zzl;
    
    /**
     *当月计划产值(不含税)
     */
    @TableField("plan_mny")
    private BigDecimal planMny;
    
    /**
     *当月计划产值(含税)
     */
    @TableField("plan_tax_mny")
    private BigDecimal planTaxMny;
    
    /**
     *当月计划税金
     */
    @TableField("plan_tax")
    private BigDecimal planTax;
    
    /**
     *本期完成率
     */
    @TableField("wcl")
    private String wcl;
    
    /**
     *年度产值不含税
     */
    @TableField("sum_mny")
    private BigDecimal sumMny;
    
    /**
     *年度产值含税
     */
    @TableField("sum_tax_mny")
    private BigDecimal sumTaxMny;
    
    /**
     *年度产值税金
     */
    @TableField("sum_tax")
    private BigDecimal sumTax;

    /**
     *同期年度产值不含税
     */
    @TableField("sum_mny_tq")
    private BigDecimal sumMnyTq;
    
    /**
     *同期年度产值含税
     */
    @TableField("sum_tax_mny_tq")
    private BigDecimal sumTaxMnyTq;
    
    /**
     *同期年度产值税金
     */
    @TableField("sum_tax_tq")
    private BigDecimal sumTaxTq;
    
    /**
     *年度增长率
     */
    @TableField("zzl_year")
    private String zzlYear;
    
    /**
     *年度计划产值不含税
     */
    @TableField("year_production_mny")
    private BigDecimal yearProductionMny;
    
    /**
     *年度计划产值含税
     */
    @TableField("year_production_tax_mny")
    private BigDecimal yearProductionTaxMny;
    
    /**
     *年度完成率
     */
    @TableField("ndmbl")
    private String ndmbl;
    
    /**
     *下月计划产值不含税
     */
    @TableField("plan_mny_next")
    private BigDecimal planMnyNext;
    
    /**
     *下月计划产值含税
     */
    @TableField("plan_tax_mny_next")
    private BigDecimal planTaxMnyNext;
    
    /**
     *下月计划税金
     */
    @TableField("plan_tax_next")
    private BigDecimal planTaxNext;

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public BigDecimal getMnyBq() {
		return mnyBq;
	}

	public void setMnyBq(BigDecimal mnyBq) {
		this.mnyBq = mnyBq;
	}

	public BigDecimal getTaxMnyBq() {
		return taxMnyBq;
	}

	public void setTaxMnyBq(BigDecimal taxMnyBq) {
		this.taxMnyBq = taxMnyBq;
	}

	public BigDecimal getTaxBq() {
		return taxBq;
	}

	public void setTaxBq(BigDecimal taxBq) {
		this.taxBq = taxBq;
	}

	public BigDecimal getMnytq() {
		return mnytq;
	}

	public void setMnytq(BigDecimal mnytq) {
		this.mnytq = mnytq;
	}

	public BigDecimal getTaxMnytq() {
		return taxMnytq;
	}

	public void setTaxMnytq(BigDecimal taxMnytq) {
		this.taxMnytq = taxMnytq;
	}

	public BigDecimal getTaxtq() {
		return taxtq;
	}

	public void setTaxtq(BigDecimal taxtq) {
		this.taxtq = taxtq;
	}

	public String getZzl() {
		return zzl;
	}

	public void setZzl(String zzl) {
		this.zzl = zzl;
	}

	public BigDecimal getPlanMny() {
		return planMny;
	}

	public void setPlanMny(BigDecimal planMny) {
		this.planMny = planMny;
	}

	public BigDecimal getPlanTaxMny() {
		return planTaxMny;
	}

	public void setPlanTaxMny(BigDecimal planTaxMny) {
		this.planTaxMny = planTaxMny;
	}

	public BigDecimal getPlanTax() {
		return planTax;
	}

	public void setPlanTax(BigDecimal planTax) {
		this.planTax = planTax;
	}

	public String getWcl() {
		return wcl;
	}

	public void setWcl(String wcl) {
		this.wcl = wcl;
	}

	public BigDecimal getSumMny() {
		return sumMny;
	}

	public void setSumMny(BigDecimal sumMny) {
		this.sumMny = sumMny;
	}

	public BigDecimal getSumTaxMny() {
		return sumTaxMny;
	}

	public void setSumTaxMny(BigDecimal sumTaxMny) {
		this.sumTaxMny = sumTaxMny;
	}

	public BigDecimal getSumTax() {
		return sumTax;
	}

	public void setSumTax(BigDecimal sumTax) {
		this.sumTax = sumTax;
	}

	public BigDecimal getSumMnyTq() {
		return sumMnyTq;
	}

	public void setSumMnyTq(BigDecimal sumMnyTq) {
		this.sumMnyTq = sumMnyTq;
	}

	public BigDecimal getSumTaxMnyTq() {
		return sumTaxMnyTq;
	}

	public void setSumTaxMnyTq(BigDecimal sumTaxMnyTq) {
		this.sumTaxMnyTq = sumTaxMnyTq;
	}

	public BigDecimal getSumTaxTq() {
		return sumTaxTq;
	}

	public void setSumTaxTq(BigDecimal sumTaxTq) {
		this.sumTaxTq = sumTaxTq;
	}

	public String getZzlYear() {
		return zzlYear;
	}

	public void setZzlYear(String zzlYear) {
		this.zzlYear = zzlYear;
	}

	public BigDecimal getYearProductionMny() {
		return yearProductionMny;
	}

	public void setYearProductionMny(BigDecimal yearProductionMny) {
		this.yearProductionMny = yearProductionMny;
	}

	public BigDecimal getYearProductionTaxMny() {
		return yearProductionTaxMny;
	}

	public void setYearProductionTaxMny(BigDecimal yearProductionTaxMny) {
		this.yearProductionTaxMny = yearProductionTaxMny;
	}

	public String getNdmbl() {
		return ndmbl;
	}

	public void setNdmbl(String ndmbl) {
		this.ndmbl = ndmbl;
	}

	public BigDecimal getPlanMnyNext() {
		return planMnyNext;
	}

	public void setPlanMnyNext(BigDecimal planMnyNext) {
		this.planMnyNext = planMnyNext;
	}

	public BigDecimal getPlanTaxMnyNext() {
		return planTaxMnyNext;
	}

	public void setPlanTaxMnyNext(BigDecimal planTaxMnyNext) {
		this.planTaxMnyNext = planTaxMnyNext;
	}

	public BigDecimal getPlanTaxNext() {
		return planTaxNext;
	}

	public void setPlanTaxNext(BigDecimal planTaxNext) {
		this.planTaxNext = planTaxNext;
	}
    
}
