package com.ejianc.business.inother.history;

import com.ejianc.business.inother.vo.OtherSettleVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class OtherSettleHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;

    private Integer isFinish; // 是否已做竣工结算(1:是，0：否)

    private Integer contractStatus;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;
    /**
     * 累计甲方报量（含税）
     */
    private BigDecimal sumQuoteTaxMny;
    /**
     * 累计结算比例
     */
    private BigDecimal sumQuoteRate;
    private List<OtherSettleVO> quoteRecord = new ArrayList<>();

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public BigDecimal getSumQuoteRate() {
        return sumQuoteRate;
    }

    public void setSumQuoteRate(BigDecimal sumQuoteRate) {
        this.sumQuoteRate = sumQuoteRate;
    }

    public List<OtherSettleVO> getQuoteRecord() {
        return quoteRecord;
    }

    public void setQuoteRecord(List<OtherSettleVO> quoteRecord) {
        this.quoteRecord = quoteRecord;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }
}
