package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 产值进度
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_production")
public class ProductionEntity extends BaseEntity {
    //累计完成产值不存，通过合同查询
    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 产值时间
     */
    @TableField("production_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productionDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 本期完成产值（含税）
     */
    @TableField("finish_tax_mny")
    private BigDecimal finishTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本期完成产值（不含税）
     */
    @TableField("finish_mny")
    private BigDecimal finishMny;
    /**
     * 累计完成产值（含税）
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;
    /**
     * 累计完成产值（不含税）
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 合同应付款
     */
    @TableField("should_pay_mny")
    private BigDecimal shouldPayMny;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;
    /**
     * 本期形象进度
     */
    @TableField("image_progress")
    private BigDecimal imageProgress;
    /**
     * 累计形象进度
     */
    @TableField("sum_image_progress")
    private BigDecimal sumImageProgress;
    /**
     * 是否被甲方报量引用过,0-否，1-是
     */
    @TableField("quote_flag")
    private Integer quoteFlag;

    @TableField(value="sum_production_tax_mny_have_this")
    private BigDecimal sumProductionTaxMnyHaveThis; // 累计完成产值(含本期)
    @TableField(value="sum_production_mny_have_this")
    private BigDecimal sumProductionMnyHaveThis; // 累计完成产值(含本期)
    @TableField(value="sum_image_progress_have_this")
    private BigDecimal sumImageProgressHaveThis; // 累计形象进度(含本期)


    @TableField(exist = false)
    @SubEntity(serviceName = "ProductionDetailService", pidName = "productionId")
    private List<ProductionDetailEntity> checkList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "ProductionClaimService", pidName = "productionId")
    private List<ProductionClaimEntity> claimList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "ProductionOtherService", pidName = "productionId")
    private List<ProductionOtherEntity> otherList = new ArrayList<>();


    public List<ProductionOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<ProductionOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public BigDecimal getSumProductionTaxMnyHaveThis() {
        return sumProductionTaxMnyHaveThis;
    }

    public void setSumProductionTaxMnyHaveThis(BigDecimal sumProductionTaxMnyHaveThis) {
        this.sumProductionTaxMnyHaveThis = sumProductionTaxMnyHaveThis;
    }

    public BigDecimal getSumProductionMnyHaveThis() {
        return sumProductionMnyHaveThis;
    }

    public void setSumProductionMnyHaveThis(BigDecimal sumProductionMnyHaveThis) {
        this.sumProductionMnyHaveThis = sumProductionMnyHaveThis;
    }

    public BigDecimal getSumImageProgressHaveThis() {
        return sumImageProgressHaveThis;
    }

    public void setSumImageProgressHaveThis(BigDecimal sumImageProgressHaveThis) {
        this.sumImageProgressHaveThis = sumImageProgressHaveThis;
    }

    public Integer getQuoteFlag() {
        return quoteFlag;
    }

    public void setQuoteFlag(Integer quoteFlag) {
        this.quoteFlag = quoteFlag;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumImageProgress() {
        return sumImageProgress;
    }

    public void setSumImageProgress(BigDecimal sumImageProgress) {
        this.sumImageProgress = sumImageProgress;
    }

    public BigDecimal getImageProgress() {
        return imageProgress;
    }

    public void setImageProgress(BigDecimal imageProgress) {
        this.imageProgress = imageProgress;
    }

    public List<ProductionDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ProductionDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public List<ProductionClaimEntity> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<ProductionClaimEntity> claimList) {
        this.claimList = claimList;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getFinishTaxMny() {
        return finishTaxMny;
    }

    public void setFinishTaxMny(BigDecimal finishTaxMny) {
        this.finishTaxMny = finishTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getFinishMny() {
        return finishMny;
    }

    public void setFinishMny(BigDecimal finishMny) {
        this.finishMny = finishMny;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Override
    public String toString() {
        return "ProductionEntity{" +
                "projectId=" + projectId +
                ", orgId=" + orgId +
                ", billCode=" + billCode +
                ", contractId=" + contractId +
                ", productionDate=" + productionDate +
                ", employeeId=" + employeeId +
                ", billState=" + billState +
                ", finishTaxMny=" + finishTaxMny +
                ", taxRate=" + taxRate +
                ", taxMny=" + taxMny +
                ", finishMny=" + finishMny +
                ", contractName=" + contractName +
                ", projectName=" + projectName +
                ", employeeName=" + employeeName +
                ", contractMny=" + contractMny +
                ", contractTaxMny=" + contractTaxMny +
                ", orgName=" + orgName +
                "}";
    }
}
